/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.task.go.GoTestStdoutExtractor;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.tasks.testing.TestOutputEvent;

public class GoTestResultsProvider
implements TestResultsProvider {
    private List<TestClassResult> testClassResults = new ArrayList<TestClassResult>();
    private Map<Long, TestClassResult> idToClassResultMap = new HashMap<Long, TestClassResult>();

    public GoTestResultsProvider(List<TestClassResult> results) {
        this.testClassResults.addAll(results);
        this.testClassResults.forEach(result -> this.idToClassResultMap.put(result.getId(), (TestClassResult)result));
    }

    public void writeAllOutput(long id, TestOutputEvent.Destination destination, Writer writer) {
        TestClassResult result = this.idToClassResultMap.get(id);
        String stdout = result.getResults().stream().map(methodResult -> (GoTestStdoutExtractor.GoTestMethodResult)((Object)methodResult)).map(GoTestStdoutExtractor.GoTestMethodResult::getMessage).filter(StringUtils::isNotEmpty).collect(Collectors.joining("\n"));
        try {
            writer.write(stdout);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeNonTestOutput(long id, TestOutputEvent.Destination destination, Writer writer) {
        throw new UnsupportedOperationException();
    }

    public void writeTestOutput(long classId, long testId, TestOutputEvent.Destination destination, Writer writer) {
        throw new UnsupportedOperationException();
    }

    public void visitClasses(Action<? super TestClassResult> visitor) {
        this.testClassResults.forEach(arg_0 -> visitor.execute(arg_0));
    }

    public boolean hasOutput(long id, TestOutputEvent.Destination destination) {
        if (destination == TestOutputEvent.Destination.StdErr) {
            return false;
        }
        TestClassResult result = this.idToClassResultMap.get(id);
        return result.getResults().stream().map(methodResult -> (GoTestStdoutExtractor.GoTestMethodResult)((Object)methodResult)).map(GoTestStdoutExtractor.GoTestMethodResult::getMessage).anyMatch(StringUtils::isNotEmpty);
    }

    public boolean isHasResults() {
        return !this.testClassResults.isEmpty();
    }

    public void close() throws IOException {
    }
}

