/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task;

import com.github.blindpirate.gogradle.core.cache.VendorSnapshoter;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.task.ResolveBuildDependencies;
import com.github.blindpirate.gogradle.task.ResolveTestDependencies;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class GoInstall
extends AbstractGolangTask {
    private static final Logger LOGGER = Logging.getLogger(GoInstall.class);
    @Inject
    private VendorSnapshoter vendorSnapshoter;
    private File vendorDir;

    public GoInstall() {
        this.setGroup(null);
        this.mustRunAfter(new Object[]{"resolveBuildDependencies", "resolveTestDependencies"});
        this.vendorDir = new File(this.getProjectDir(), "vendor");
    }

    @TaskAction
    public void installDependenciesToVendor() {
        this.setGogradleGlobalContext();
        IOUtils.forceMkdir(this.vendorDir);
        this.vendorSnapshoter.loadPersistenceCache();
        GolangDependencySet buildSet = this.getTask(ResolveBuildDependencies.class).getFlatDependencies();
        GolangDependencySet testSet = this.getTask(ResolveTestDependencies.class).getFlatDependencies();
        GolangDependencySet result = GolangDependencySet.merge(buildSet, testSet);
        IOUtils.markAndDeleteUnmarked(this.vendorDir, dir -> this.vendorIsUpToDate((File)dir, this.vendorDir, result));
        result.forEach(this::installIfNecessary);
        this.removeFilesUnderVendor();
        this.vendorSnapshoter.savePersistenceCache();
    }

    private void removeFilesUnderVendor() {
        IOUtils.safeListFiles(this.vendorDir).stream().filter(File::isFile).forEach(IOUtils::deleteQuitely);
    }

    private void installIfNecessary(GolangDependency dependency) {
        File targetDir = new File(this.getProjectDir(), "vendor/" + dependency.getName());
        IOUtils.forceMkdir(targetDir);
        if (IOUtils.dirIsEmpty(targetDir)) {
            ResolvedDependency resolvedDependency = (ResolvedDependency)dependency;
            resolvedDependency.installTo(targetDir);
            this.vendorSnapshoter.updateCache(resolvedDependency, targetDir);
        } else {
            IOUtils.deleteQuitely(new File(targetDir, "vendor"));
            LOGGER.info("{} is up-to-date, skip installing {}", (Object)targetDir, (Object)dependency);
        }
    }

    private boolean vendorIsUpToDate(File currentDir, File vendorDir, GolangDependencySet dependencySet) {
        String packagePath = StringUtils.toUnixString(vendorDir.toPath().relativize(currentDir.toPath()));
        Optional<GolangDependency> existed = dependencySet.findByName(packagePath);
        if (!existed.isPresent()) {
            return false;
        }
        ResolvedDependency resolvedDependency = (ResolvedDependency)existed.get();
        return this.vendorSnapshoter.isUpToDate(resolvedDependency, currentDir);
    }
}

