/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.crossplatform;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;

public enum Os {
    ANDROID,
    DARWIN,
    DRAGONFLY,
    FREEBSD,
    LINUX,
    NACL,
    NETBSD,
    OPENBSD,
    PLAN9,
    SOLARIS,
    WINDOWS{

        @Override
        public String exeExtension() {
            return ".exe";
        }

        @Override
        public String archiveExtension() {
            return ".zip";
        }
    }
    ,
    ZOS;

    private static Os hostOs;
    private static final Map<Os, Boolean> OS_DETECTION_MAP;

    public String toString() {
        return this.name().toLowerCase();
    }

    public String exeExtension() {
        return "";
    }

    public String archiveExtension() {
        return ".tar.gz";
    }

    public static Os getHostOs() {
        if (hostOs == null) {
            hostOs = Os.detectOs();
        }
        return hostOs;
    }

    public static Os of(String lowercase) {
        for (Os os : Os.values()) {
            if (!os.toString().equals(lowercase)) continue;
            return os;
        }
        throw new IllegalArgumentException("Unrecognized os: " + lowercase);
    }

    private static Os detectOs() {
        Optional<Map.Entry> result = OS_DETECTION_MAP.entrySet().stream().filter(Map.Entry::getValue).findFirst();
        if (result.isPresent()) {
            return (Os)((Object)result.get().getKey());
        }
        throw new IllegalStateException("Unrecognized operation system:" + System.getProperty("os.name"));
    }

    static {
        OS_DETECTION_MAP = ImmutableMap.builder().put((Object)LINUX, (Object)SystemUtils.IS_OS_LINUX).put((Object)WINDOWS, (Object)SystemUtils.IS_OS_WINDOWS).put((Object)DARWIN, (Object)SystemUtils.IS_OS_MAC_OSX).put((Object)FREEBSD, (Object)SystemUtils.IS_OS_FREE_BSD).put((Object)NETBSD, (Object)SystemUtils.IS_OS_NET_BSD).put((Object)SOLARIS, (Object)SystemUtils.IS_OS_SOLARIS).put((Object)ZOS, (Object)SystemUtils.IS_OS_ZOS).build();
    }
}

