/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.GolangRepositoryHandler;
import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.GolangRepositoryPattern;
import com.github.blindpirate.gogradle.core.IncompleteGolangPackage;
import com.github.blindpirate.gogradle.core.LocalDirectoryGolangPackage;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RepositoryHandlerPathResolver
implements PackagePathResolver {
    private final GolangRepositoryHandler repositoryHandler;

    @Inject
    public RepositoryHandlerPathResolver(GolangRepositoryHandler repositoryHandler) {
        this.repositoryHandler = repositoryHandler;
    }

    @Override
    public Optional<GolangPackage> produce(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        Optional<GolangRepositoryPattern> repo = this.repositoryHandler.findMatchedRepository(StringUtils.toUnixString(path));
        if (repo.isPresent()) {
            if (repo.get().isIncomplete()) {
                return Optional.of(this.buildIncompletePackage(path));
            }
            return Optional.of(this.buildPackage(path, path, repo.get()));
        }
        for (int i = path.getNameCount() - 1; i > 0; --i) {
            Path subpath = path.subpath(0, i);
            Optional<GolangRepositoryPattern> repository = this.repositoryHandler.findMatchedRepository(StringUtils.toUnixString(subpath));
            if (!repository.isPresent() || repository.get().isIncomplete()) continue;
            return Optional.of(this.buildPackage(path, subpath, repository.get()));
        }
        return Optional.empty();
    }

    private GolangPackage buildIncompletePackage(Path path) {
        return IncompleteGolangPackage.of(path);
    }

    private GolangPackage buildPackage(Path path, Path rootPath, GolangRepositoryPattern repository) {
        String rootPathString = StringUtils.toUnixString(rootPath);
        VcsType vcsType = repository.getVcsType();
        String url = repository.getUrl(rootPathString);
        String dir = repository.getDir(rootPathString);
        Assert.isTrue(url != null || dir != null, "You must specify dir or url for " + rootPathString);
        if (url != null) {
            GolangRepository repo = GolangRepository.newSubstitutedRepository(vcsType, url);
            return VcsGolangPackage.builder().withPath(path).withRootPath(rootPath).withRepository(repo).build();
        }
        return LocalDirectoryGolangPackage.of(rootPath, path, dir);
    }
}

