/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.HttpUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import com.github.blindpirate.gogradle.vcs.VcsType;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

@Singleton
public class MetadataPackagePathResolver
implements PackagePathResolver {
    public static final String GO_USER_AGENT = "Go-http-client/1.1";
    private static final Logger LOGGER = Logging.getLogger(MetadataPackagePathResolver.class);
    private final HttpUtils httpUtils;

    @Inject
    public MetadataPackagePathResolver(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    @Override
    @DebugLog
    public Optional<GolangPackage> produce(String packagePath) {
        if (GogradleGlobal.isOffline()) {
            LOGGER.info("Fetching metadata of {} is skipped since it is offline now.", (Object)packagePath);
            return Optional.empty();
        }
        Optional<GolangPackage> httpsResult = this.fetchViaWeb(packagePath, "https://" + packagePath);
        if (httpsResult.isPresent()) {
            return httpsResult;
        }
        return this.fetchViaWeb(packagePath, "http://" + packagePath);
    }

    private Optional<GolangPackage> fetchViaWeb(String packagePath, String url) {
        try {
            String html = this.fetchHtml(url);
            Document document = Jsoup.parse((String)html);
            Elements elements = document.select("meta[name=go-import]");
            Optional<GoImportMetaTag> metaTag = this.findMatchedMetaTag(packagePath, url, elements);
            if (!metaTag.isPresent()) {
                LOGGER.debug("Cannot find matched meta tag in response of {}", (Object)url);
                return Optional.empty();
            }
            return Optional.of(this.buildPackageInfo(packagePath, metaTag.get()));
        }
        catch (IOException e) {
            LOGGER.info("Exception in accessing {}", (Object)url, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<GoImportMetaTag> findMatchedMetaTag(String packagePath, String url, Elements elements) {
        return elements.stream().map(element -> new GoImportMetaTag(element.attr("content"))).filter(tag -> packagePath.startsWith(((GoImportMetaTag)tag).rootPath)).findFirst();
    }

    private GolangPackage buildPackageInfo(String packagePath, GoImportMetaTag metaTag) {
        GolangRepository repository = GolangRepository.newOriginalRepository(metaTag.vcs, metaTag.repoUrl);
        return VcsGolangPackage.builder().withPath(Paths.get(packagePath, new String[0])).withRepository(repository).withRootPath(Paths.get(metaTag.rootPath, new String[0])).build();
    }

    private String fetchHtml(String url) throws IOException {
        String realUrl = this.httpUtils.appendQueryParams(url, (Map<String, String>)ImmutableMap.of((Object)"go-get", (Object)"1"));
        ImmutableMap headers = ImmutableMap.of((Object)"user-agent", (Object)GO_USER_AGENT);
        return this.httpUtils.get(realUrl, (Map<String, String>)headers);
    }

    static class GoImportMetaTag {
        private String rootPath;
        private VcsType vcs;
        private String repoUrl;

        GoImportMetaTag(String content) {
            String[] array = StringUtils.splitAndTrim(content, " ");
            Assert.isTrue(array.length > 2, "Invalid content:" + content);
            this.rootPath = array[0];
            this.vcs = VcsType.of(array[1]).get();
            this.repoUrl = array[2];
        }
    }
}

