/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.cache.GlobalCacheManager;
import com.github.blindpirate.gogradle.core.cache.GlobalCacheMetadata;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GlobalCachePackagePathResolver
implements PackagePathResolver {
    private final GlobalCacheManager globalCacheManager;

    @Inject
    public GlobalCachePackagePathResolver(GlobalCacheManager globalCacheManager) {
        this.globalCacheManager = globalCacheManager;
    }

    @Override
    @DebugLog
    public Optional<GolangPackage> produce(String packagePath) {
        if (!GogradleGlobal.isRefreshDependencies()) {
            Path path = Paths.get(packagePath, new String[0]);
            for (int i = path.getNameCount(); i > 0; --i) {
                Optional<GlobalCacheMetadata.GolangRepositoryMetadata> originalRepo;
                Path subpath = path.subpath(0, i);
                Optional<GlobalCacheMetadata> metadata = this.globalCacheManager.getMetadata(subpath);
                if (!metadata.isPresent() || !(originalRepo = metadata.get().getRepositories().stream().filter(GolangRepository::isOriginal).findFirst()).isPresent()) continue;
                VcsGolangPackage pkg = VcsGolangPackage.builder().withPath(packagePath).withRootPath(subpath).withRepository(originalRepo.get()).build();
                return Optional.of(pkg);
            }
        }
        return Optional.empty();
    }
}

