/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.AbstractPackagePathResolver;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class GithubGitlabPackagePathResolver
extends AbstractPackagePathResolver {
    private final String host;

    public GithubGitlabPackagePathResolver(String host) {
        this.host = host;
    }

    @Override
    protected boolean isIncomplete(String packagePath) {
        return Paths.get(packagePath, new String[0]).getNameCount() < 3;
    }

    @Override
    protected boolean cannotRecognize(String packagePath) {
        return !this.host.equals(Paths.get(packagePath, new String[0]).getName(0).toString().toLowerCase());
    }

    @Override
    protected GolangPackage doProduce(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        String sshUrl = String.format("git@%s.git", StringUtils.toUnixString(path.subpath(0, 3)).replaceFirst("/", ":"));
        String httpsUrl = String.format("https://%s.git", StringUtils.toUnixString(path.subpath(0, 3)));
        GolangRepository repository = GolangRepository.newOriginalRepository(VcsType.GIT, Arrays.asList(httpsUrl, sshUrl));
        return VcsGolangPackage.builder().withPath(path).withRootPath(path.subpath(0, 3)).withRepository(repository).build();
    }
}

