/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.AbstractPackagePathResolver;
import com.github.blindpirate.gogradle.util.DataExchange;
import com.github.blindpirate.gogradle.util.HttpUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BitbucketPackagePathResolver
extends AbstractPackagePathResolver {
    private static final String BITBUCKET_HOST = "bitbucket.org";
    private static final String BITBUCKET_API_PREFIX = "https://api.bitbucket.org/2.0/repositories/";
    private final HttpUtils httpUtils;

    @Inject
    public BitbucketPackagePathResolver(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    @Override
    protected GolangPackage doProduce(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        BitbucketApiModel packageInfo = this.queryByApi(path);
        return this.buildByApiResponse(path, packageInfo);
    }

    private GolangPackage buildByApiResponse(Path path, BitbucketApiModel packageInfo) {
        List<String> urls = packageInfo.links.clone.stream().map(BitbucketApiModel.LinksBean.CloneBean::getHref).collect(Collectors.toList());
        Collections.sort(urls);
        GolangRepository repository = GolangRepository.newOriginalRepository(packageInfo.scm, urls);
        return VcsGolangPackage.builder().withRepository(repository).withPath(path).withRootPath(path.subpath(0, 3)).build();
    }

    private BitbucketApiModel queryByApi(Path path) {
        String url = BITBUCKET_API_PREFIX + StringUtils.toUnixString(path.subpath(1, 3));
        try {
            String response = this.httpUtils.get(url);
            return DataExchange.parseJson(response, BitbucketApiModel.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected boolean isIncomplete(String packagePath) {
        return Paths.get(packagePath, new String[0]).getNameCount() < 3;
    }

    @Override
    protected boolean cannotRecognize(String packagePath) {
        return !BITBUCKET_HOST.equals(Paths.get(packagePath, new String[0]).getName(0).toString());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class BitbucketApiModel {
        @JsonProperty(value="scm")
        private String scm;
        @JsonProperty(value="website")
        private String website;
        @JsonProperty(value="has_wiki")
        private boolean haswiki;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="links")
        private LinksBean links;
        @JsonProperty(value="fork_policy")
        private String forkpolicy;
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="language")
        private String language;
        @JsonProperty(value="createdon")
        private String createdon;
        @JsonProperty(value="full_name")
        private String fullname;
        @JsonProperty(value="has_issues")
        private boolean hasissues;
        @JsonProperty(value="owner")
        private OwnerBean owner;
        @JsonProperty(value="updated_on")
        private String updatedon;
        @JsonProperty(value="size")
        private int size;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="slug")
        private String slug;
        @JsonProperty(value="is_private")
        private boolean isprivate;
        @JsonProperty(value="description")
        private String description;

        private BitbucketApiModel() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class OwnerBean {
            @JsonProperty(value="username")
            private String username;
            @JsonProperty(value="display_name")
            private String displayname;
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="uuid")
            private String uuid;
            @JsonProperty(value="links")
            private LinksBeanX links;

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class LinksBeanX {
                @JsonProperty(value="self")
                private SelfBeanX self;
                @JsonProperty(value="html")
                private HtmlBeanX html;
                @JsonProperty(value="avatar")
                private AvatarBeanX avatar;

                @JsonIgnoreProperties(ignoreUnknown=true)
                public static class AvatarBeanX {
                    @JsonProperty(value="href")
                    private String href;
                }

                @JsonIgnoreProperties(ignoreUnknown=true)
                public static class HtmlBeanX {
                    @JsonProperty(value="href")
                    private String href;
                }

                @JsonIgnoreProperties(ignoreUnknown=true)
                public static class SelfBeanX {
                    @JsonProperty(value="href")
                    private String href;
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class LinksBean {
            @JsonProperty(value="watchers")
            private WatchersBean watchers;
            @JsonProperty(value="branches")
            private BranchesBean branches;
            @JsonProperty(value="tags")
            private TagsBean tags;
            @JsonProperty(value="commits")
            private CommitsBean commits;
            @JsonProperty(value="self")
            private SelfBean self;
            @JsonProperty(value="html")
            private HtmlBean html;
            @JsonProperty(value="avatar")
            private AvatarBean avatar;
            @JsonProperty(value="hooks")
            private HooksBean hooks;
            @JsonProperty(value="forks")
            private ForksBean forks;
            @JsonProperty(value="downloads")
            private DownloadsBean downloads;
            @JsonProperty(value="pullrequests")
            private PullrequestsBean pullrequests;
            @JsonProperty(value="clone")
            private List<CloneBean> clone;

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class CloneBean {
                @JsonProperty(value="href")
                private String href;
                @JsonProperty(value="name")
                private String name;

                public String getHref() {
                    return this.href;
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class PullrequestsBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class DownloadsBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class ForksBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class HooksBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class AvatarBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class HtmlBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class SelfBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class CommitsBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class TagsBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class BranchesBean {
                @JsonProperty(value="href")
                private String href;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class WatchersBean {
                @JsonProperty(value="href")
                private String href;
            }
        }
    }
}

