/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.tree;

import com.github.blindpirate.gogradle.core.GolangConfiguration;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.tree.DependencyTreeNode;
import com.github.blindpirate.gogradle.core.exceptions.ResolutionStackWrappingException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class DependencyTreeFactory {
    public DependencyTreeNode getTree(ResolveContext context, ResolvedDependency rootProject) {
        this.resolve(rootProject, context);
        return this.getSubTree(context.getConfiguration(), rootProject, new HashSet<ResolvedDependency>());
    }

    private DependencyTreeNode getSubTree(GolangConfiguration configuration, ResolvedDependency resolvedDependency, Set<ResolvedDependency> existedDependenciesInTree) {
        ResolvedDependency finalDependency = configuration.getDependencyRegistry().retrieve(resolvedDependency.getName());
        boolean hasExistedInTree = existedDependenciesInTree.contains(finalDependency);
        DependencyTreeNode node = DependencyTreeNode.withOrignalAndFinal(resolvedDependency, finalDependency, hasExistedInTree);
        if (!hasExistedInTree) {
            existedDependenciesInTree.add(finalDependency);
            for (GolangDependency dependency : finalDependency.getDependencies()) {
                node.addChild(this.getSubTree(configuration, dependency.resolve(null), existedDependenciesInTree));
            }
        }
        return node;
    }

    private void resolve(ResolvedDependency rootProject, ResolveContext context) {
        LinkedList<ResolveOperation> queue = new LinkedList<ResolveOperation>();
        queue.add(new ResolveOperation(rootProject, context));
        while (!queue.isEmpty()) {
            ResolveOperation item = (ResolveOperation)queue.remove();
            if (!context.getDependencyRegistry().register(item.dependencyToPropagate)) continue;
            try {
                item.dependencyToPropagate.getDependencies().stream().map(dep -> this.createSubContextAndResolve((GolangDependency)dep, item.context)).forEach(queue::add);
            }
            catch (Throwable e) {
                throw ResolutionStackWrappingException.wrapWithResolutionStack(e, item.context);
            }
        }
    }

    private ResolveOperation createSubContextAndResolve(GolangDependency dependency, ResolveContext parentContext) {
        ResolveContext subContext = parentContext.createSubContext(dependency);
        ResolvedDependency resolvedDependency = dependency.resolve(subContext);
        return new ResolveOperation(resolvedDependency, subContext);
    }

    private static class ResolveOperation {
        private ResolvedDependency dependencyToPropagate;
        private ResolveContext context;

        private ResolveOperation(ResolvedDependency dependencyToPropagate, ResolveContext context) {
            this.dependencyToPropagate = dependencyToPropagate;
            this.context = context;
        }
    }
}

