/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.resolve;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.cache.GlobalCacheManager;
import com.github.blindpirate.gogradle.core.cache.ProjectCacheManager;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.install.VendorSupportMixin;
import com.github.blindpirate.gogradle.core.dependency.resolve.CacheEnabledDependencyResolverMixin;
import com.github.blindpirate.gogradle.core.dependency.resolve.DependencyManager;
import com.github.blindpirate.gogradle.core.exceptions.DependencyInstallationException;
import com.github.blindpirate.gogradle.core.exceptions.DependencyResolutionException;
import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public abstract class AbstractVcsDependencyManager<VERSION>
implements CacheEnabledDependencyResolverMixin,
VendorSupportMixin,
DependencyManager {
    private static final Logger LOGGER = Logging.getLogger(AbstractVcsDependencyManager.class);
    private final GlobalCacheManager globalCacheManager;
    private final ProjectCacheManager projectCacheManager;

    public AbstractVcsDependencyManager(GlobalCacheManager globalCacheManager, ProjectCacheManager projectCacheManager) {
        this.globalCacheManager = globalCacheManager;
        this.projectCacheManager = projectCacheManager;
    }

    @Override
    public ProjectCacheManager getProjectCacheManager() {
        return this.projectCacheManager;
    }

    @Override
    public ResolvedDependency doResolve(ResolveContext context, NotationDependency dependency) {
        try {
            this.globalCacheManager.startSession((VcsGolangPackage)dependency.getPackage());
            this.resolveRepository(dependency);
            File vcsRoot = this.globalCacheManager.getGlobalCacheRepoDir();
            VERSION version = this.determineVersion(vcsRoot, dependency);
            this.resetToSpecificVersion(vcsRoot, version);
            ResolvedDependency resolvedDependency = this.createResolvedDependency(dependency, vcsRoot, version, context);
            return resolvedDependency;
        }
        catch (Exception e) {
            throw DependencyResolutionException.cannotResolveDependency(dependency, e);
        }
        finally {
            this.globalCacheManager.endSession();
        }
    }

    @Override
    public void install(ResolvedDependency dependency, File targetDirectory) {
        try {
            ResolvedDependency realDependency = this.determineDependency(dependency);
            this.globalCacheManager.startSession((VcsGolangPackage)this.determineDependency(dependency).getPackage());
            this.resolveRepository(realDependency);
            this.doInstall(dependency, realDependency, targetDirectory);
        }
        catch (Exception e) {
            throw DependencyInstallationException.cannotResetResolvedDependency(dependency, e);
        }
        finally {
            this.globalCacheManager.endSession();
        }
    }

    private void doInstall(ResolvedDependency dependency, ResolvedDependency realDependency, File targetDirectory) {
        File globalCachePath = this.globalCacheManager.getGlobalCacheRepoDir();
        this.doReset(realDependency, globalCachePath);
        Path srcPath = globalCachePath.toPath().resolve(this.determineRelativePath(dependency)).normalize();
        IOUtils.copyDependencies(srcPath.toFile(), targetDirectory, dependency.getSubpackages());
    }

    protected abstract void doReset(ResolvedDependency var1, File var2);

    protected abstract ResolvedDependency createResolvedDependency(NotationDependency var1, File var2, VERSION var3, ResolveContext var4);

    protected abstract void resetToSpecificVersion(File var1, VERSION var2);

    protected abstract VERSION determineVersion(File var1, NotationDependency var2);

    private void resolveRepository(GolangDependency dependency) {
        File repoRoot = this.globalCacheManager.getGlobalCacheRepoDir();
        List<String> expectedUrls = ((VcsGolangPackage)VcsGolangPackage.class.cast(dependency.getPackage())).getUrls();
        if (this.repositoryNeedInit(repoRoot)) {
            this.initRepository(dependency.getName(), expectedUrls, repoRoot);
            this.globalCacheManager.repoUpdated();
        } else if (this.repositoryNeedUpdate(repoRoot, dependency)) {
            this.updateRepository(dependency, repoRoot);
            this.globalCacheManager.repoUpdated();
        }
    }

    private boolean repositoryNeedUpdate(File repoRoot, GolangDependency dependency) {
        if (GogradleGlobal.isOffline()) {
            LOGGER.info("Cannot update {} in {} since it is offline now.", (Object)dependency, (Object)repoRoot);
            return false;
        }
        if (this.globalCacheManager.currentRepositoryIsUpToDate()) {
            LOGGER.info("Skip updating {} in {} since it is up-to-date.", (Object)dependency, (Object)repoRoot);
            return false;
        }
        if (!this.versionExistsInRepo(repoRoot, dependency)) {
            LOGGER.info("{} does not exist in {}, updating will be performed.", (Object)dependency, (Object)repoRoot);
            return true;
        }
        if (GogradleGlobal.isRefreshDependencies()) {
            LOGGER.info("Updating {} in {} since refresh flag is present.", (Object)dependency, (Object)repoRoot);
            return true;
        }
        LOGGER.info("Skip updating {} in {}.", (Object)dependency, (Object)repoRoot);
        return false;
    }

    protected abstract boolean versionExistsInRepo(File var1, GolangDependency var2);

    protected abstract void updateRepository(GolangDependency var1, File var2);

    protected abstract void initRepository(String var1, List<String> var2, File var3);

    private boolean repositoryNeedInit(File repoRoot) {
        return IOUtils.dirIsEmpty(repoRoot);
    }
}

