/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.strategy;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.core.GolangConfigurationManager;
import com.github.blindpirate.gogradle.core.dependency.AbstractGolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.lock.LockedDependencyManager;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.strategy.DependencyProduceStrategy;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GogradleRootProduceStrategy
implements DependencyProduceStrategy {
    private final GolangPluginSetting settings;
    private final GolangConfigurationManager configurationManager;
    private final LockedDependencyManager lockedDependencyManager;

    @Inject
    public GogradleRootProduceStrategy(GolangPluginSetting settings, GolangConfigurationManager configurationManager, LockedDependencyManager lockedDependencyManager) {
        this.settings = settings;
        this.configurationManager = configurationManager;
        this.lockedDependencyManager = lockedDependencyManager;
    }

    @Override
    @DebugLog
    public GolangDependencySet produce(ResolvedDependency dependency, File projectRoot, DependencyVisitor visitor, String configuration) {
        GolangDependencySet result = this.determineDependencies(dependency, projectRoot, configuration);
        this.setFirstLevel(result);
        if (result.isEmpty()) {
            return visitor.visitSourceCodeDependencies(dependency, projectRoot, configuration);
        }
        return result;
    }

    private GolangDependencySet determineDependencies(ResolvedDependency dependency, File projectRoot, String configuration) {
        GolangDependencySet declaredDependencies = this.getDependenciesInBuildDotGradle(configuration);
        if (this.lockedDependencyManager.canRecognize(projectRoot)) {
            GolangDependencySet lockedDependencies = this.lockedDependencyManager.produce(dependency, projectRoot, configuration);
            return this.settings.getBuildMode().determine(declaredDependencies, lockedDependencies);
        }
        return declaredDependencies;
    }

    private void setFirstLevel(GolangDependencySet set) {
        set.forEach(dependency -> ((AbstractGolangDependency)AbstractGolangDependency.class.cast(dependency)).setFirstLevel(true));
    }

    private GolangDependencySet getDependenciesInBuildDotGradle(String configuration) {
        return this.configurationManager.getByName(configuration).getDependencies();
    }
}

