/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.external.dep;

import com.google.common.collect.ImmutableMap;
import com.moandjiezana.toml.Toml;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GopkgDotLockModel {
    private static final Map<String, String> PROPERTY_NAME_CONVERSION = ImmutableMap.of((Object)"packages", (Object)"subpackages", (Object)"revision", (Object)"commit", (Object)"version", (Object)"tag", (Object)"source", (Object)"url");
    private static final Map<String, Function<List, List>> PROPERTY_CONVERSION = ImmutableMap.of((Object)"packages", GopkgDotLockModel::convertSubpackages);

    public static List<Map<String, Object>> parse(File file) {
        Toml toml = new Toml().read(file);
        List projects = toml.getList("projects");
        GopkgDotLockModel.convertProperties(projects);
        GopkgDotLockModel.convertPropertyNames(projects);
        return projects;
    }

    private static void convertPropertyNames(List<Map<String, Object>> projects) {
        projects.forEach(project -> PROPERTY_NAME_CONVERSION.forEach((nameBefore, nameAfter) -> {
            Object value = project.remove(nameBefore);
            if (value != null) {
                project.put(nameAfter, value);
            }
        }));
    }

    private static void convertProperties(List<Map<String, Object>> projects) {
        projects.forEach(project -> PROPERTY_CONVERSION.forEach((key, fn) -> {
            if (project.containsKey(key)) {
                List value = (List)project.get(key);
                value = (List)fn.apply(value);
                project.put(key, value);
            }
        }));
    }

    private static List<String> convertSubpackages(List<String> subpackagesInDepDotLock) {
        return subpackagesInDepDotLock.stream().map(GopkgDotLockModel::convertDotToTripleDot).collect(Collectors.toList());
    }

    private static String convertDotToTripleDot(String s) {
        return ".".equals(s) ? "..." : s;
    }
}

