/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.ExternalDependencyFactory;
import com.github.blindpirate.gogradle.core.dependency.produce.SourceCodeDependencyFactory;
import com.github.blindpirate.gogradle.core.dependency.produce.VendorDependencyFactory;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import com.google.inject.BindingAnnotation;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultDependencyVisitor
implements DependencyVisitor {
    private final List<ExternalDependencyFactory> externalDependencyFactories;
    private final SourceCodeDependencyFactory sourceCodeDependencyFactory;
    private final VendorDependencyFactory vendorDependencyFactory;

    @Inject
    public DefaultDependencyVisitor(@ExternalDependencyFactories List<ExternalDependencyFactory> externalDependencyFactories, SourceCodeDependencyFactory sourceCodeDependencyFactory, VendorDependencyFactory vendorDependencyFactory) {
        this.externalDependencyFactories = externalDependencyFactories;
        this.sourceCodeDependencyFactory = sourceCodeDependencyFactory;
        this.vendorDependencyFactory = vendorDependencyFactory;
    }

    @Override
    @DebugLog
    public GolangDependencySet visitExternalDependencies(ResolvedDependency dependency, File rootDir, String configuration) {
        for (ExternalDependencyFactory factory : this.externalDependencyFactories) {
            if (!factory.canRecognize(rootDir)) continue;
            return factory.produce(dependency, rootDir, configuration);
        }
        return GolangDependencySet.empty();
    }

    @Override
    @DebugLog
    public GolangDependencySet visitVendorDependencies(ResolvedDependency dependency, File rootDir, String configuration) {
        if ("build".equals(configuration)) {
            return this.vendorDependencyFactory.produce(dependency, rootDir);
        }
        return GolangDependencySet.empty();
    }

    @Override
    @DebugLog
    public GolangDependencySet visitSourceCodeDependencies(ResolvedDependency dependency, File rootDir, String configuration) {
        return this.sourceCodeDependencyFactory.produce(dependency, rootDir, configuration);
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExternalDependencyFactories {
    }
}

