/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.dependency.AbstractNotationDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.VendorResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.install.LocalDirectoryDependencyManager;
import com.github.blindpirate.gogradle.core.exceptions.DependencyResolutionException;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class LocalDirectoryDependency
extends AbstractNotationDependency
implements ResolvedDependency {
    private static final File EMPTY_DIR = null;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logging.getLogger(LocalDirectoryDependency.class);
    private File rootDir;
    private GolangDependencySet dependencies = GolangDependencySet.empty();

    public static LocalDirectoryDependency fromLocal(String name, File rootDir) {
        LocalDirectoryDependency ret = new LocalDirectoryDependency();
        ret.setName(name);
        ret.setDir(rootDir);
        return ret;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setDir(String dir) {
        if (!"GOGRADLE_EMPTY_DIR".equals(dir)) {
            this.setDir(new File(dir));
        }
    }

    protected void setDir(File rootDir) {
        Assert.isTrue(this.rootDir == null, "rootDir can be set only once!");
        this.rootDir = rootDir;
        if (!IOUtils.isValidDirectory(rootDir)) {
            throw DependencyResolutionException.directoryIsInvalid(rootDir);
        }
    }

    @Override
    public long getUpdateTime() {
        if (this.rootDir == EMPTY_DIR) {
            return 0L;
        }
        return this.rootDir.lastModified();
    }

    public void setDependencies(GolangDependencySet dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public GolangDependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public Map<String, Object> toLockedNotation() {
        if (this.rootDir == EMPTY_DIR) {
            return null;
        }
        LOGGER.warn("You are locking {} which exists only on your local filesystem, which may cause issues on other one's computer.", (Object)this.getRootDir());
        Map<String, Object> ret = MapUtils.asMap("name", this.getName(), "dir", StringUtils.toUnixString(this.rootDir));
        if (!this.getSubpackages().contains("...")) {
            ret.put("subpackages", new ArrayList<String>(this.getSubpackages()));
        }
        return ret;
    }

    @Override
    public void installTo(File targetDirectory) {
        if (this.rootDir == EMPTY_DIR) {
            return;
        }
        GogradleGlobal.getInstance(LocalDirectoryDependencyManager.class).install(this, targetDirectory);
    }

    @Override
    public String formatVersion() {
        return this.rootDir == EMPTY_DIR ? "" : StringUtils.toUnixString(this.rootDir);
    }

    @Override
    public String getVersion() {
        return Instant.ofEpochMilli(this.getUpdateTime()).toString();
    }

    @Override
    public String toString() {
        return this.getName() + "@" + StringUtils.toUnixString(this.rootDir);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LocalDirectoryDependency that = (LocalDirectoryDependency)o;
        return Objects.equals(this.rootDir, that.rootDir);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rootDir, super.hashCode());
    }

    @Override
    public CacheScope getCacheScope() {
        return CacheScope.BUILD;
    }

    @Override
    protected ResolvedDependency doResolve(ResolveContext context) {
        if (this.rootDir == EMPTY_DIR) {
            return this;
        }
        return GogradleGlobal.getInstance(LocalDirectoryDependencyManager.class).resolve(context, this);
    }

    @Override
    public Object clone() {
        LocalDirectoryDependency ret = (LocalDirectoryDependency)super.clone();
        ret.transitiveDepExclusions = this.getTransitiveDepExclusions();
        Assert.isTrue(this.onlyVendorDependenciesCanHaveDescendants());
        ret.dependencies = this.dependencies.clone();
        ret.dependencies.flatten().forEach(dependency -> this.resetVendorHostIfNecessary((GolangDependency)dependency, ret));
        return ret;
    }

    private void resetVendorHostIfNecessary(GolangDependency dependency, ResolvedDependency clone) {
        if (dependency instanceof VendorResolvedDependency) {
            ((VendorResolvedDependency)VendorResolvedDependency.class.cast(dependency)).setHostDependency(clone);
        }
    }

    private boolean onlyVendorDependenciesCanHaveDescendants() {
        return this.dependencies.stream().filter(d -> d instanceof ResolvedDependency && !(d instanceof VendorResolvedDependency)).map(d -> (ResolvedDependency)d).allMatch(d -> d.getDependencies().isEmpty());
    }
}

