/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.core.dependency.DependencyRegistry;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class DefaultDependencyRegistry
implements DependencyRegistry {
    private Map<String, ResolvedDependency> packages = new HashMap<String, ResolvedDependency>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(ResolvedDependency dependencyToResolve) {
        Map<String, ResolvedDependency> map = this.packages;
        synchronized (map) {
            ResolvedDependency existent = this.retrieve(dependencyToResolve.getName());
            if (existent == null) {
                return this.registerSucceed(dependencyToResolve);
            }
            if (StringUtils.isPrefix(existent.getName(), dependencyToResolve.getName())) {
                throw new IllegalStateException("Package " + existent.getName() + " conflict with " + dependencyToResolve.getName());
            }
            if (this.theyAreAllFirstLevel(existent, dependencyToResolve)) {
                throw new IllegalStateException("First-level package " + dependencyToResolve.getName() + " conflict!");
            }
            if (existent.isFirstLevel()) {
                return false;
            }
            if (dependencyToResolve.isFirstLevel()) {
                return this.registerSucceed(dependencyToResolve);
            }
            if (this.existentDependencyIsOutOfDate(existent, dependencyToResolve)) {
                return this.registerSucceed(dependencyToResolve);
            }
            return false;
        }
    }

    private boolean registerSucceed(ResolvedDependency resolvedDependency) {
        this.packages.put(resolvedDependency.getName(), resolvedDependency);
        return true;
    }

    @Override
    public ResolvedDependency retrieve(String name) {
        Path path = Paths.get(name, new String[0]);
        for (int i = path.getNameCount(); i > 0; --i) {
            Path subpath = path.subpath(0, i);
            ResolvedDependency ret = this.packages.get(StringUtils.toUnixString(subpath));
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private boolean existentDependencyIsOutOfDate(ResolvedDependency existingDependency, ResolvedDependency resolvedDependency) {
        return existingDependency.getUpdateTime() < resolvedDependency.getUpdateTime();
    }

    private boolean theyAreAllFirstLevel(ResolvedDependency existedModule, ResolvedDependency resolvedDependency) {
        return existedModule.isFirstLevel() && resolvedDependency.isFirstLevel();
    }
}

