/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.core.dependency.AbstractGolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.ConfigureUtils;
import com.github.blindpirate.gogradle.util.MapUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractNotationDependency
extends AbstractGolangDependency
implements NotationDependency {
    public static final Predicate<GolangDependency> NO_TRANSITIVE_DEP_PREDICATE = NoTransitivePredicate.NO_TRANSITIVE_PREDICATE;
    public static final String VERSION_KEY = "version";
    private ResolvedDependency resolvedDependency;
    protected Set<Predicate<GolangDependency>> transitiveDepExclusions = new HashSet<Predicate<GolangDependency>>();

    @Override
    public Set<Predicate<GolangDependency>> getTransitiveDepExclusions() {
        return new HashSet<Predicate<GolangDependency>>(this.transitiveDepExclusions);
    }

    @Override
    public ResolvedDependency resolve(ResolveContext context) {
        if (this.resolvedDependency == null) {
            this.resolvedDependency = this.doResolve(context);
        }
        return this.resolvedDependency;
    }

    protected abstract ResolvedDependency doResolve(ResolveContext var1);

    public void exclude(Map<String, Object> map) {
        this.transitiveDepExclusions.add(PropertiesExclusionPredicate.of(map));
    }

    public void setTransitive(boolean transitive) {
        if (transitive) {
            this.transitiveDepExclusions.remove(NO_TRANSITIVE_DEP_PREDICATE);
        } else {
            this.transitiveDepExclusions.add(NO_TRANSITIVE_DEP_PREDICATE);
        }
    }

    @Override
    public Object clone() {
        AbstractNotationDependency ret = (AbstractNotationDependency)super.clone();
        ret.transitiveDepExclusions = this.getTransitiveDepExclusions();
        ret.resolvedDependency = null;
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractNotationDependency that = (AbstractNotationDependency)o;
        return Objects.equals(this.transitiveDepExclusions, that.transitiveDepExclusions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.transitiveDepExclusions, super.hashCode());
    }

    public static class PropertiesExclusionPredicate
    implements Predicate<GolangDependency>,
    Serializable {
        private Map<String, Object> properties;

        public static PropertiesExclusionPredicate of(Map<String, Object> properties) {
            PropertiesExclusionPredicate ret = new PropertiesExclusionPredicate();
            ret.properties = Assert.isNotNull(properties);
            return ret;
        }

        @Override
        public boolean test(GolangDependency dependency) {
            HashMap<String, Object> tmp = new HashMap<String, Object>(this.properties);
            String name = MapUtils.getString(tmp, "name");
            tmp.remove("name");
            if (name != null) {
                return dependency.getName().startsWith(name) && ConfigureUtils.match(tmp, dependency);
            }
            return ConfigureUtils.match(tmp, dependency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertiesExclusionPredicate that = (PropertiesExclusionPredicate)o;
            return this.properties.equals(that.properties);
        }

        public int hashCode() {
            return this.properties.hashCode();
        }
    }

    public static enum NoTransitivePredicate implements Predicate<GolangDependency>
    {
        NO_TRANSITIVE_PREDICATE;


        @Override
        public boolean test(GolangDependency dependency) {
            return true;
        }
    }
}

