/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.cache.DirectorySnapshot;
import com.github.blindpirate.gogradle.core.cache.PersistenceCacheHelper;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.map.LRUMap;
import org.gradle.api.Project;

@Singleton
public class VendorSnapshoter {
    private Map<ResolvedDependency, DirectorySnapshot> cache = new LRUMap(1000);
    private final Project project;
    private final File persistenceFile;

    @Inject
    public VendorSnapshoter(Project project) {
        this.project = project;
        this.persistenceFile = new File(project.getProjectDir(), ".gogradle/cache/VendorSnapshot-0.8.bin");
    }

    public void loadPersistenceCache() {
        PersistenceCacheHelper.load(this.cache, this.persistenceFile);
    }

    public void savePersistenceCache() {
        PersistenceCacheHelper.save(this.cache, this.persistenceFile);
    }

    public boolean isUpToDate(ResolvedDependency resolvedDependency, File dir) {
        DirectorySnapshot lastInstallationSnapshot = this.cache.get(resolvedDependency);
        if (lastInstallationSnapshot == null) {
            return false;
        }
        return lastInstallationSnapshot.isUpToDate(this.project.getProjectDir(), dir);
    }

    public void updateCache(ResolvedDependency resolvedDependency, File dir) {
        if (resolvedDependency.getCacheScope() == CacheScope.PERSISTENCE) {
            this.cache.put(resolvedDependency, DirectorySnapshot.of(this.project.getProjectDir(), dir));
        }
    }
}

