/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.cache.CloneBackedCache;
import com.github.blindpirate.gogradle.core.cache.PersistenceNotationToResolvedCache;
import com.github.blindpirate.gogradle.core.cache.PersistenceResolvedToDependenciesCache;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProjectCacheManager {
    private final CloneBackedCache<NotationDependency, ResolvedDependency> buildScopedNotationToResolvedCache = new CloneBackedCache();
    private final CloneBackedCache<ResolvedDependency, GolangDependencySet> buildScopedResolvedToDependenciesCache = new CloneBackedCache();
    private final PersistenceNotationToResolvedCache persistenceNotationToResolvedCache;
    private final PersistenceResolvedToDependenciesCache persistenceResolvedToDependenciesCache;

    @Inject
    public ProjectCacheManager(PersistenceResolvedToDependenciesCache persistenceResolvedToDependenciesCache, PersistenceNotationToResolvedCache persistenceNotationToResolvedCache) {
        this.persistenceNotationToResolvedCache = persistenceNotationToResolvedCache;
        this.persistenceResolvedToDependenciesCache = persistenceResolvedToDependenciesCache;
    }

    public void loadPersistenceCache() {
        this.persistenceNotationToResolvedCache.load();
        this.persistenceResolvedToDependenciesCache.load();
    }

    public void savePersistenceCache() {
        this.persistenceNotationToResolvedCache.save();
        this.persistenceResolvedToDependenciesCache.save();
    }

    public ResolvedDependency resolve(NotationDependency notationDependency, Function<NotationDependency, ResolvedDependency> constructor) {
        if (notationDependency.getCacheScope() == CacheScope.BUILD) {
            return (ResolvedDependency)this.buildScopedNotationToResolvedCache.get((Object)notationDependency, constructor);
        }
        return (ResolvedDependency)this.persistenceNotationToResolvedCache.get(notationDependency, constructor);
    }

    public GolangDependencySet produce(ResolvedDependency resolvedDependency, Function<ResolvedDependency, GolangDependencySet> constructor) {
        if (resolvedDependency.getCacheScope() == CacheScope.BUILD) {
            return (GolangDependencySet)this.buildScopedResolvedToDependenciesCache.get((Object)resolvedDependency, constructor);
        }
        return (GolangDependencySet)this.persistenceResolvedToDependenciesCache.get(resolvedDependency, constructor);
    }
}

