/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class DirectorySnapshot
implements Serializable {
    private String hash;

    public static DirectorySnapshot of(File projectRoot, File targetDir) {
        return new DirectorySnapshot(DirectorySnapshot.md5(projectRoot, targetDir));
    }

    private static String md5(File projectRoot, File targetDir) {
        List<File> allFilesInDir = IOUtils.listAllDescendents(targetDir).stream().sorted(File::compareTo).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        allFilesInDir.forEach(file -> {
            Path relativePath = projectRoot.toPath().relativize(file.toPath());
            sb.append(file.isFile() ? "f" : "d").append(File.pathSeparatorChar).append(StringUtils.toUnixString(relativePath)).append(File.pathSeparatorChar).append(file.length()).append(File.pathSeparatorChar).append(file.lastModified()).append(File.pathSeparatorChar);
        });
        return DigestUtils.md5Hex((String)sb.toString());
    }

    public boolean isUpToDate(File projectRoot, File targetDir) {
        if (!targetDir.exists() || targetDir.isFile()) {
            return false;
        }
        return DirectorySnapshot.md5(projectRoot, targetDir).equals(this.hash);
    }

    private DirectorySnapshot(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }
}

