/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.build;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.build.BuildManager;
import com.github.blindpirate.gogradle.build.SubprocessReader;
import com.github.blindpirate.gogradle.core.exceptions.BuildException;
import com.github.blindpirate.gogradle.crossplatform.Arch;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.crossplatform.Os;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.util.ExceptionHandler;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.ProcessUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@Singleton
public class DefaultBuildManager
implements BuildManager {
    private static final String PROJECT_GOPATH = "project_gopath";
    private static final String SRC = "src";
    private static final Set<String> TOOL_COMMANDS_SUPPORTING_BUILD_TAG = ImmutableSet.of((Object)"vet");
    private static final Logger LOGGER = Logging.getLogger(DefaultBuildManager.class);
    private final Project project;
    private final GoBinaryManager goBinaryManager;
    private final GolangPluginSetting setting;
    private final ProcessUtils processUtils;
    private String gopath;
    private List<Path> gopaths;

    @Inject
    public DefaultBuildManager(Project project, GoBinaryManager goBinaryManager, GolangPluginSetting setting, ProcessUtils processUtils) {
        this.project = project;
        this.goBinaryManager = goBinaryManager;
        this.setting = setting;
        this.processUtils = processUtils;
    }

    @Override
    public void prepareProjectGopathIfNecessary() {
        String systemGopath = System.getenv("GOPATH");
        if (this.currentProjectMatchesGopath(systemGopath)) {
            LOGGER.quiet("Found global GOPATH: {}.", new Object[]{systemGopath});
            this.gopath = systemGopath;
            this.gopaths = Arrays.stream(systemGopath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        } else {
            this.createProjectSymbolicLinkIfNotExist();
            Path path = this.getGogradleBuildDir().resolve(PROJECT_GOPATH).toAbsolutePath();
            this.gopath = StringUtils.toUnixString(path);
            this.gopaths = Collections.singletonList(path);
            LOGGER.quiet("Use project GOPATH: {}", new Object[]{this.gopath});
        }
    }

    private boolean currentProjectMatchesGopath(String systemGopath) {
        if (StringUtils.isBlank(systemGopath)) {
            return false;
        }
        return Stream.of(systemGopath.split(File.pathSeparator)).anyMatch(this::currentProjectMatchesSingleGopath);
    }

    private boolean currentProjectMatchesSingleGopath(String gopath) {
        return Paths.get(gopath, new String[0]).resolve(SRC).resolve(this.setting.getPackagePath()).equals(this.project.getProjectDir().toPath());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void createProjectSymbolicLinkIfNotExist() {
        Path link = this.getGogradleBuildDir().resolve(PROJECT_GOPATH).resolve(SRC).resolve(this.setting.getPackagePath());
        if (!link.toFile().exists()) {
            IOUtils.forceMkdir(link.getParent().toFile());
            Path targetPath = this.project.getProjectDir().toPath();
            this.createSymbolicLink(link, link.getParent().relativize(targetPath));
        }
    }

    private void createSymbolicLink(Path link, Path target) {
        try {
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw BuildException.cannotCreateSymbolicLink(link, e);
        }
    }

    private Path getGogradleBuildDir() {
        return this.project.getProjectDir().toPath().resolve(".gogradle");
    }

    @Override
    public int go(List<String> args, Map<String, String> env) {
        return this.go(args, env, null, null);
    }

    private List<String> insertBuildTags(List<String> cmd) {
        if (this.setting.getBuildTags().isEmpty() || cmd.isEmpty()) {
            return cmd;
        }
        if (this.isToolCmdButNotSupportTags(cmd)) {
            return cmd;
        }
        int tagsOffset = "tool".equals(cmd.get(0)) ? 2 : 1;
        ArrayList<String> ret = new ArrayList<String>(cmd);
        ret.add(tagsOffset, "-tags");
        String tagsArg = this.setting.getBuildTags().stream().collect(Collectors.joining(" "));
        ret.add(tagsOffset + 1, "'" + tagsArg + "'");
        return ret;
    }

    private boolean isToolCmdButNotSupportTags(List<String> cmd) {
        return cmd.size() >= 2 && "tool".equals(cmd.get(0)) && !TOOL_COMMANDS_SUPPORTING_BUILD_TAG.contains(cmd.get(1));
    }

    @Override
    public int go(List<String> args, Map<String, String> env, Consumer<String> stdoutLineConsumer, Consumer<String> stderrLineConsumer) {
        return this.go(args, env, stdoutLineConsumer, stderrLineConsumer, false);
    }

    @Override
    public int go(List<String> args, Map<String, String> env, Consumer<String> stdoutLineConsumer, Consumer<String> stderrLineConsumer, boolean continueOnFailure) {
        List<String> cmdAndArgs = CollectionUtils.asStringList(this.getGoBinary(), this.insertBuildTags(args));
        return this.run(cmdAndArgs, env, stdoutLineConsumer, stderrLineConsumer, continueOnFailure);
    }

    @Override
    public int run(List<String> args, Map<String, String> env, Consumer<String> stdoutLineConsumer, Consumer<String> stderrLineConsumer) {
        return this.run(args, env, stdoutLineConsumer, stderrLineConsumer, false);
    }

    @Override
    public int run(List<String> args, Map<String, String> env, Consumer<String> stdoutLineConsumer, Consumer<String> stderrLineConsumer, boolean continueOnFailure) {
        Map<String, String> finalEnv = this.determineEnv(env);
        List<String> finalArgs = this.renderArgs(args, finalEnv);
        return this.doRun(finalArgs, finalEnv, stdoutLineConsumer, stderrLineConsumer, continueOnFailure);
    }

    private List<String> renderArgs(List<String> args, Map<String, String> env) {
        HashMap<String, String> context = new HashMap<String, String>(env);
        context.put("PROJECT_NAME", this.project.getName());
        context.put("PROJECT_VERSION", (String)this.project.getVersion());
        return args.stream().map(s -> StringUtils.render(s, context)).collect(Collectors.toList());
    }

    private int doRun(List<String> args, Map<String, String> env, Consumer<String> stdoutLineConsumer, Consumer<String> stderrLineConsumer, boolean continueOnFailure) {
        Consumer<String> consumer = stdoutLineConsumer == null ? arg_0 -> ((Logger)LOGGER).quiet(arg_0) : (stdoutLineConsumer = stdoutLineConsumer);
        stderrLineConsumer = stderrLineConsumer == null ? arg_0 -> ((Logger)LOGGER).error(arg_0) : stderrLineConsumer;
        Process process = this.processUtils.run(args, this.determineEnv(env), this.project.getProjectDir());
        CountDownLatch latch = new CountDownLatch(2);
        new SubprocessReader(process::getInputStream, stdoutLineConsumer, latch).start();
        new SubprocessReader(process::getErrorStream, stderrLineConsumer, latch).start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw ExceptionHandler.uncheckException(e);
        }
        try {
            int ret = process.waitFor();
            if (!continueOnFailure) {
                this.ensureProcessReturnZero(ret, args, env);
            }
            return ret;
        }
        catch (InterruptedException e) {
            throw ExceptionHandler.uncheckException(e);
        }
    }

    private void ensureProcessReturnZero(int retcode, List<String> args, Map<String, String> env) {
        if (retcode != 0) {
            String message = "\nCommand:\n " + String.join((CharSequence)" ", args) + "\nEnv:\n" + StringUtils.formatEnv(env);
            throw BuildException.processInteractionFailed(retcode, message);
        }
    }

    private Map<String, String> determineEnv(Map<String, String> env) {
        Map<String, String> defaultEnvs = MapUtils.asMap("GOPATH", this.getGopath(), "GOROOT", StringUtils.toUnixString(this.goBinaryManager.getGoroot().toAbsolutePath()), "GOOS", Os.getHostOs().toString(), "GOEXE", Os.getHostOs().exeExtension(), "GOARCH", Arch.getHostArch().toString());
        defaultEnvs.putAll(env);
        return defaultEnvs;
    }

    private String getGoBinary() {
        return StringUtils.toUnixString(this.goBinaryManager.getBinaryPath().toAbsolutePath());
    }

    @Override
    public String getGopath() {
        return this.gopath;
    }

    @Override
    public List<Path> getGopaths() {
        return this.gopaths;
    }
}

