/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs;

import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.dependency.AbstractResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.resolve.DependencyManager;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.vcs.VcsNotationDependency;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VcsResolvedDependency
extends AbstractResolvedDependency {
    private static final int COMMIT_PREFIX_LENGTH = 7;
    private String tag;

    private VcsResolvedDependency(String name, String commitId, long commitTime) {
        super(name, commitId, commitTime);
    }

    public VcsType getVcsType() {
        return this.getPackage().getVcsType();
    }

    @Override
    protected DependencyManager getInstaller() {
        return this.getVcsType().getService(DependencyManager.class);
    }

    @Override
    public Map<String, Object> toLockedNotation() {
        Map<String, Object> ret = MapUtils.asMap("name", this.getName(), "vcs", this.getVcsType().getName(), "commit", this.getVersion());
        if (this.getUrls().size() == 1) {
            ret.put("url", this.getUrls().get(0));
        } else {
            ret.put("urls", this.getUrls());
        }
        if (!this.containsAllSubpackages()) {
            ret.put("subpackages", new ArrayList<String>(this.getSubpackages()));
        }
        return ret;
    }

    @Override
    public String formatVersion() {
        if (this.tag != null) {
            return this.tag + "(" + this.getVersion().substring(0, 7) + ")";
        }
        return this.getVersion().substring(0, 7);
    }

    @Override
    public String toString() {
        return this.getName() + "#" + this.getVersion();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        VcsResolvedDependency that = (VcsResolvedDependency)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getVcsType(), (Object)that.getVcsType()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getUrls(), that.getUrls());
    }

    private List<String> getUrls() {
        return this.getPackage().getRepository().getUrls();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getVcsType(), this.getVersion(), this.getUrls()});
    }

    @Override
    public VcsGolangPackage getPackage() {
        return (VcsGolangPackage)super.getPackage();
    }

    public static GitMercurialResolvedDependencyBuilder builder() {
        return new GitMercurialResolvedDependencyBuilder();
    }

    public static final class GitMercurialResolvedDependencyBuilder {
        private VcsNotationDependency notationDependency;
        private String commitId;
        private long commitTime;

        private GitMercurialResolvedDependencyBuilder() {
        }

        public GitMercurialResolvedDependencyBuilder withNotationDependency(NotationDependency notationDependency) {
            this.notationDependency = (VcsNotationDependency)notationDependency;
            return this;
        }

        public GitMercurialResolvedDependencyBuilder withCommitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public GitMercurialResolvedDependencyBuilder withCommitTime(long commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public VcsResolvedDependency build() {
            VcsResolvedDependency ret = new VcsResolvedDependency(this.notationDependency.getName(), this.commitId, this.commitTime);
            ret.tag = this.notationDependency.getTag();
            ret.setPackage(this.notationDependency.getPackage());
            ret.setSubpackages(this.notationDependency.getSubpackages());
            ret.setFirstLevel(this.notationDependency.isFirstLevel());
            return ret;
        }
    }
}

