/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs;

import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.dependency.AbstractNotationDependency;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.util.List;
import java.util.Objects;

public abstract class VcsNotationDependency
extends AbstractNotationDependency {
    public static final String LATEST_COMMIT = "LATEST_COMMIT";
    public static final String URL_KEY = "url";
    public static final String URLS_KEY = "urls";
    public static final String BRANCH_KEY = "branch";
    public static final String TAG_KEY = "tag";
    public static final String COMMIT_KEY = "commit";
    private String commit;
    private String tag;
    private String branch;

    public String getCommit() {
        return this.commit;
    }

    public String getTag() {
        return this.tag;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<String> getUrls() {
        return ((VcsGolangPackage)VcsGolangPackage.class.cast(this.getPackage())).getUrls();
    }

    public void setVersion(String version) {
        this.commit = version;
    }

    @Override
    public String getVersion() {
        return this.commit;
    }

    @Override
    public CacheScope getCacheScope() {
        if (StringUtils.isNotBlank(this.getCommit()) && !LATEST_COMMIT.equals(this.getCommit())) {
            return CacheScope.PERSISTENCE;
        }
        return CacheScope.BUILD;
    }

    public boolean isLatest() {
        return LATEST_COMMIT.equals(this.getCommit());
    }

    @Override
    public String toString() {
        String ret = this.getName() + ':' + (this.commit == null ? "" : " commit='" + this.commit + "',") + (this.tag == null ? "" : " tag='" + this.tag + "',") + (this.branch == null ? "" : " branch='" + this.branch + "',") + (this.getUrls() == null ? "" : " urls=" + this.getUrls() + ",") + (this.containsAllSubpackages() ? "" : " subpackages='" + this.getSubpackages() + "',");
        return ret.substring(0, ret.length() - 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VcsNotationDependency that = (VcsNotationDependency)o;
        return Objects.equals(this.commit, that.commit) && Objects.equals(this.getUrls(), that.getUrls());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.commit, this.getUrls(), super.hashCode());
    }
}

