/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util.logging;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.service.ServiceRegistry;

public class ProgressMonitorInputStream
extends InputStream {
    private static final int BUF_SIZE = 4096;
    private InputStream delegate;
    private ProgressLogger logger;
    private int totalBytes;
    private int bufferedBytes;
    private boolean completed;

    public ProgressMonitorInputStream(String url, InputStream delegate) {
        this.delegate = delegate;
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)GogradleGlobal.getInstance(ServiceRegistry.class).get(ProgressLoggerFactory.class);
        this.logger = progressLoggerFactory.newOperation(this.getClass());
        String description = "Start downloading from " + url;
        this.logger.start(description, description);
    }

    @Override
    public int read() throws IOException {
        int ret = this.delegate.read();
        if (this.completed) {
            return ret;
        }
        if (ret == -1) {
            this.progress();
            this.logger.completed();
            this.completed = true;
        } else {
            ++this.bufferedBytes;
            if (this.bufferedBytes >= 4096) {
                this.progress();
            }
        }
        return ret;
    }

    private void progress() {
        this.totalBytes += this.bufferedBytes;
        this.bufferedBytes = 0;
        this.logger.progress(IOUtils.byteCountToDisplaySize(this.totalBytes) + " downloaded");
    }
}

