/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util.logging;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DebugLogMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = Logging.getLogger(DebugLogMethodInterceptor.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        this.beforeMethod(methodInvocation);
        long startTime = System.nanoTime();
        Throwable exception = null;
        Object ret = null;
        try {
            Object object = ret = methodInvocation.proceed();
            return object;
        }
        catch (Throwable e) {
            exception = e;
            throw e;
        }
        finally {
            long endTime = System.nanoTime();
            this.afterMethod(methodInvocation, ret, exception, endTime - startTime);
        }
    }

    private void afterMethod(MethodInvocation methodInvocation, Object returnValue, Throwable e, long nanoseconds) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        Object target = methodInvocation.getThis();
        Method method = methodInvocation.getMethod();
        if (e == null) {
            LOGGER.debug("Exiting method {} of class {}, total time is {} ms, return {}", new Object[]{method.getName(), target.getClass().getSimpleName(), this.toString(nanoseconds), returnValue});
        } else {
            LOGGER.debug("Exiting method {} of class {}, total time is {} ms, exception is {}", new Object[]{method.getName(), target.getClass().getSimpleName(), this.toString(nanoseconds), this.toString(e)});
        }
    }

    private String toString(Throwable e) {
        return "[" + e.getClass().getSimpleName() + "]" + e.getMessage();
    }

    private String toString(long nanoseconds) {
        return String.format("%.3f", (double)nanoseconds / 1000000.0);
    }

    private void beforeMethod(MethodInvocation methodInvocation) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        Object target = methodInvocation.getThis();
        Object[] arguments = methodInvocation.getArguments();
        Method method = methodInvocation.getMethod();
        LOGGER.debug("Entering method {} of class {}, the arguments is {}", new Object[]{method.getName(), target.getClass().getSimpleName(), this.toString(arguments)});
    }

    private String toString(Object[] arguments) {
        StringBuilder sb = new StringBuilder("[");
        Arrays.stream(arguments).forEach(arg -> sb.append(arg));
        sb.append("]");
        return sb.toString();
    }
}

