/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.ExceptionHandler;
import groovy.text.GStringTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class StringUtils {
    public static String removeEnd(String s, String suffix) {
        return org.apache.commons.lang3.StringUtils.removeEnd((String)s, (String)suffix);
    }

    public static String[] splitAndTrim(String str, String regex) {
        String[] array = str.split(regex);
        return (String[])Stream.of(array).map(org.apache.commons.lang3.StringUtils::trimToNull).filter(Objects::nonNull).toArray(String[]::new);
    }

    public static boolean pathStartsWith(String a, String b) {
        Path aPath = Paths.get(a, new String[0]);
        Path bPath = Paths.get(b, new String[0]);
        return aPath.startsWith(bPath);
    }

    public static boolean isNotBlank(String s) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s);
    }

    public static boolean isBlank(String s) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s);
    }

    public static boolean allBlank(String ... strs) {
        return Arrays.stream(strs).allMatch(StringUtils::isBlank);
    }

    public static boolean isEmpty(String s) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)s);
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean fileNameStartsWithAny(File file, String ... prefix) {
        return StringUtils.startsWithAny(file.getName(), prefix);
    }

    public static boolean fileNameStartsWithDotOrUnderline(File file) {
        return StringUtils.fileNameStartsWithAny(file, "_", ".");
    }

    public static boolean fileNameEndsWithAny(File file, String ... prefix) {
        return StringUtils.endsWithAny(file.getName(), prefix);
    }

    public static boolean startsWithAny(String str, String ... prefix) {
        return Stream.of(prefix).anyMatch(str::startsWith);
    }

    public static boolean endsWithAny(String str, String ... suffix) {
        return Stream.of(suffix).anyMatch(str::endsWith);
    }

    public static boolean fileNameEqualsAny(File file, String ... name) {
        return Stream.of(name).anyMatch(file.getName()::equals);
    }

    public static String toUnixString(File file) {
        return StringUtils.toUnixString(file.getAbsolutePath());
    }

    public static boolean isPrefix(String a, String b) {
        Assert.isNotNull(a);
        Assert.isNotNull(b);
        return !a.equals(b) && b.startsWith(a);
    }

    public static int count(String str, char ch) {
        return org.apache.commons.lang3.StringUtils.countMatches((CharSequence)str, (char)ch);
    }

    public static String toUnixString(Path path) {
        return path.toString().replace("\\", "/");
    }

    public static String toUnixString(String s) {
        return s.replace("\\", "/");
    }

    public static String render(String template, Map<String, Object> context) {
        try {
            context = new HashMap<String, Object>(context);
            return new GStringTemplateEngine().createTemplate(template).make(context).toString();
        }
        catch (IOException | ClassNotFoundException e) {
            throw ExceptionHandler.uncheckException(e);
        }
    }

    public static String substring(String s, int start, int end) {
        return org.apache.commons.lang3.StringUtils.substring((String)s, (int)start, (int)end);
    }

    public static String formatEnv(Map<String, String> env) {
        return String.join((CharSequence)"\n", env.entrySet().stream().map(entry -> " " + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()));
    }

    public static int lastIndexOf(String s, String substr) {
        return org.apache.commons.lang3.StringUtils.lastIndexOf((CharSequence)s, (CharSequence)substr);
    }

    public static void appendNSpaces(StringBuilder sb, int n) {
        while (n-- > 0) {
            sb.append(' ');
        }
    }

    public static String trimToNull(String str) {
        return org.apache.commons.lang3.StringUtils.trimToNull((String)str);
    }

    public static String capitalizeFirstLetter(String s) {
        Assert.isNotBlank(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static Stream<String> eachSubPath(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        return IntStream.range(0, path.getNameCount()).mapToObj(i -> path.subpath(0, i + 1)).map(StringUtils::toUnixString);
    }

    public static Stream<String> eachSubPathReverse(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        return IntStream.range(0, path.getNameCount()).mapToObj(i -> path.subpath(0, path.getNameCount() - i)).map(StringUtils::toUnixString);
    }
}

