/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class CollectionUtils {
    public static <T> boolean isEmpty(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static <T> List<T> immutableList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <T> List<T> collectOptional(Optional<T> ... optionals) {
        ArrayList ret = new ArrayList();
        for (Optional<Object> optional : optionals) {
            optional.ifPresent(ret::add);
        }
        return ret;
    }

    public static List<String> asStringList(Object ... elements) {
        ArrayList<String> ret = new ArrayList<String>();
        Stream.of(elements).forEach(element -> {
            if (element instanceof Collection) {
                ret.addAll((Collection)element);
            } else if (element != null && element.getClass().isArray()) {
                Stream.of((String[])element).forEach(ret::add);
            } else {
                ret.add((String)element);
            }
        });
        return ret;
    }

    public static <T> List<T> flatten(List<List<T>> lists) {
        return lists.stream().collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    public static <T extends Comparable<? super T>> List<T> toSorted(Collection<T> c) {
        ArrayList<T> ret = new ArrayList<T>(c);
        Collections.sort(ret);
        return ret;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        return org.apache.commons.collections4.CollectionUtils.containsAny(coll1, coll2);
    }

    public static <T> Set<T> intersection(Collection<T> c1, Collection<T> c2) {
        HashSet<T> set = new HashSet<T>(c1);
        set.retainAll(c2);
        return set;
    }
}

