/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go.test;

import com.github.blindpirate.gogradle.task.go.PackageTestResult;
import com.github.blindpirate.gogradle.task.go.test.AbstractGoTestResultExtractor;
import com.github.blindpirate.gogradle.util.DateUtils;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.tasks.testing.TestResult;

@Deprecated
public class PlainGoTestResultExtractor
extends AbstractGoTestResultExtractor {
    private static final Map<String, TestResult.ResultType> RESULT_TYPE_MAP = ImmutableMap.of((Object)"PASS", (Object)TestResult.ResultType.SUCCESS, (Object)"FAIL", (Object)TestResult.ResultType.FAILURE, (Object)"SKIP", (Object)TestResult.ResultType.SKIPPED);
    private static final Pattern TEST_START_LINE_PATTERN = Pattern.compile("=== RUN\\s+(\\w+)(/?)");

    @Override
    protected List<AbstractGoTestResultExtractor.GoTestMethodResult> extractMethodResults(PackageTestResult packageTestResult) {
        List<String> stdout = this.removeTailMessages(packageTestResult.getStdout());
        List<Pair<Integer, String>> testStartIndicesAndNames = this.extractStartIndiceAndTestMethodNames(stdout);
        ArrayList<AbstractGoTestResultExtractor.GoTestMethodResult> ret = new ArrayList<AbstractGoTestResultExtractor.GoTestMethodResult>();
        for (int i = 0; i < testStartIndicesAndNames.size(); ++i) {
            int currentIndex = (Integer)testStartIndicesAndNames.get(i).getLeft();
            String currentMethodName = (String)testStartIndicesAndNames.get(i).getRight();
            int nextIndex = i == testStartIndicesAndNames.size() - 1 ? stdout.size() : ((Integer)testStartIndicesAndNames.get(i + 1).getLeft()).intValue();
            ret.add(this.extractOneTestMethod(currentMethodName, stdout.subList(currentIndex, nextIndex)));
        }
        return ret;
    }

    private List<String> removeTailMessages(List<String> stdout) {
        for (int i = 1; i <= 4 && i <= stdout.size(); ++i) {
            String line = stdout.get(stdout.size() - i).trim();
            if (!"FAIL".equals(line) && !"PASS".equals(line)) continue;
            return stdout.subList(0, stdout.size() - i);
        }
        return stdout;
    }

    private List<Pair<Integer, String>> extractStartIndiceAndTestMethodNames(List<String> stdout) {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (int i = 0; i < stdout.size(); ++i) {
            Optional<String> testName = this.getRootTestNameFromLine(stdout.get(i));
            if (!testName.isPresent()) continue;
            ret.add((Pair<Integer, String>)Pair.of((Object)i, (Object)testName.get()));
        }
        return ret;
    }

    private Optional<String> getRootTestNameFromLine(String line) {
        if (!(line = line.trim()).startsWith("=== RUN")) {
            return Optional.empty();
        }
        Matcher matcher = TEST_START_LINE_PATTERN.matcher(line);
        if (matcher.find() && "".equals(matcher.group(2))) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private AbstractGoTestResultExtractor.GoTestMethodResult extractOneTestMethod(String testMethodName, List<String> resultLines) {
        Pattern testEndLinePattern = Pattern.compile("--- (PASS|FAIL|SKIP):\\s+" + testMethodName + "\\s+\\(((\\d+)(\\.\\d+)?)s\\)");
        String message = String.join((CharSequence)"\n", resultLines);
        for (String line : resultLines) {
            Matcher matcher;
            if (!line.contains("--- PASS") && !line.contains("--- FAIL") && !line.contains("--- SKIP") || !(matcher = testEndLinePattern.matcher(line)).find()) continue;
            TestResult.ResultType resultType = RESULT_TYPE_MAP.get(matcher.group(1));
            long duration = DateUtils.toMilliseconds(Double.parseDouble(matcher.group(2)));
            return this.createTestMethodResult(testMethodName, resultType, message, duration);
        }
        return this.createTestMethodResult(testMethodName, TestResult.ResultType.FAILURE, message, 0L);
    }
}

