/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go.test;

import com.github.blindpirate.gogradle.task.go.PackageTestResult;
import com.github.blindpirate.gogradle.task.go.test.AbstractGoTestResultExtractor;
import com.github.blindpirate.gogradle.task.go.test.GoTestEvent;
import com.github.blindpirate.gogradle.task.go.test.GoTestResultJsonModel;
import com.github.blindpirate.gogradle.util.DataExchange;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestResult;

public class JsonGoTestResultExtractor
extends AbstractGoTestResultExtractor {
    private static final Logger LOGGER = Logging.getLogger(JsonGoTestResultExtractor.class);
    static final Pattern TEST_NAME_IN_OUTPUT_PATTERN = Pattern.compile("(?:===|---) (RUN|PASS|SKIP|FAIL):?\\s+([^\\s]+)(?:\\s+\\(((\\d+)(\\.\\d+)?)s\\))?");

    @Override
    protected List<AbstractGoTestResultExtractor.GoTestMethodResult> extractMethodResults(PackageTestResult packageTestResult) {
        Map jsonModels = packageTestResult.getStdout().stream().map(this::tryConvertToEvent).filter(Optional::isPresent).map(Optional::get).filter(GoTestEvent::hasTestName).collect(Collectors.groupingBy(GoTestEvent::getTestName, LinkedHashMap::new, Collectors.toList()));
        return jsonModels.entrySet().stream().map(this::convertToMethodResult).collect(Collectors.toList());
    }

    private AbstractGoTestResultExtractor.GoTestMethodResult convertToMethodResult(Map.Entry<String, List<GoTestEvent>> entry) {
        String testName = entry.getKey();
        List<GoTestEvent> testEvents = entry.getValue();
        TestResult.ResultType resultType = testEvents.stream().map(GoTestEvent::getResultType).filter(Objects::nonNull).findAny().orElse(null);
        String message = testEvents.stream().map(GoTestEvent::getOutput).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        long duration = testEvents.stream().map(GoTestEvent::getDurationMillis).filter(Objects::nonNull).findAny().get();
        return this.createTestMethodResult(testName, resultType, message, duration);
    }

    private Optional<GoTestEvent> tryConvertToEvent(String line) {
        return this.tryConvertToJsonModel(line).map(GoTestResultJsonModel::toTestEvent);
    }

    private Optional<GoTestResultJsonModel> tryConvertToJsonModel(String line) {
        try {
            return Optional.of(DataExchange.parseJson(line, GoTestResultJsonModel.class));
        }
        catch (Exception e) {
            LOGGER.debug("Exception when processing line: " + line, (Throwable)e);
            return Optional.empty();
        }
    }
}

