/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go.test;

import com.github.blindpirate.gogradle.task.go.PackageTestResult;
import com.github.blindpirate.gogradle.task.go.test.GoTestResultExtractor;
import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestResult;

public abstract class AbstractGoTestResultExtractor
implements GoTestResultExtractor {
    private static final Logger LOGGER = Logging.getLogger(AbstractGoTestResultExtractor.class);
    private static final String SETUP_FAILED_ERROR = "[setup failed]";
    private static final String BUILD_FAILED_ERROR = "[build failed]";
    private static final String CANNOT_LOAD_PACKAGE_ERROR = "can't load package";
    private static final String CANNOT_FIND_PACKAGE_ERROR = "cannot find package";
    private static final String RETURN_NON_ZERO = "go test return ";
    static final String TEST_START = "=== RUN";
    static final String TEST_PASS = "--- PASS";
    static final String TEST_FAIL = "--- FAIL";
    static final String TEST_SKIP = "--- SKIP";
    protected static final AtomicLong GLOBAL_COUNTER = new AtomicLong(0L);

    protected abstract List<GoTestMethodResult> extractMethodResults(PackageTestResult var1);

    protected TestClassResult methodResultsToClassResult(String className, List<GoTestMethodResult> methodResults) {
        TestClassResult ret = new TestClassResult(GLOBAL_COUNTER.incrementAndGet(), className, 0L);
        methodResults.forEach(arg_0 -> ((TestClassResult)ret).add(arg_0));
        return ret;
    }

    @Override
    public List<TestClassResult> extractTestResult(PackageTestResult result) {
        if (this.stdoutContains(result, SETUP_FAILED_ERROR)) {
            return this.testFailToStartUpResult(result, SETUP_FAILED_ERROR);
        }
        if (this.stdoutContains(result, BUILD_FAILED_ERROR)) {
            return this.testFailToStartUpResult(result, BUILD_FAILED_ERROR);
        }
        if (this.stdoutContains(result, CANNOT_LOAD_PACKAGE_ERROR)) {
            return this.testFailToStartUpResult(result, CANNOT_LOAD_PACKAGE_ERROR);
        }
        if (this.stdoutContains(result, CANNOT_FIND_PACKAGE_ERROR)) {
            return this.testFailToStartUpResult(result, CANNOT_FIND_PACKAGE_ERROR);
        }
        if (this.testFailed(result)) {
            return this.testFailToStartUpResult(result, RETURN_NON_ZERO + result.getCode());
        }
        return this.testStartUpSuccessfullyResult(result);
    }

    private List<TestClassResult> testStartUpSuccessfullyResult(PackageTestResult result) {
        Map<File, String> testFileContents = this.loadTestFiles(result.getTestFiles());
        List<GoTestMethodResult> results = this.extractMethodResults(result);
        Map<File, List<GoTestMethodResult>> testFileToResults = this.groupByTestFile(results, testFileContents);
        return testFileToResults.entrySet().stream().map(entry -> {
            String className = this.determineClassName(result.getPackagePath(), ((File)entry.getKey()).getName());
            return this.methodResultsToClassResult(className, (List)entry.getValue());
        }).collect(Collectors.toList());
    }

    private Map<File, String> loadTestFiles(List<File> testFiles) {
        return testFiles.stream().collect(Collectors.toMap(Function.identity(), IOUtils::toString));
    }

    private Map<File, List<GoTestMethodResult>> groupByTestFile(List<GoTestMethodResult> results, Map<File, String> testFiles) {
        return results.stream().collect(Collectors.groupingBy(result -> this.findTestFileOfMethod(testFiles, result.getGoTestMethodName()), LinkedHashMap::new, Collectors.toList()));
    }

    private File findTestFileOfMethod(Map<File, String> testFileContents, String goTestMethodName) {
        LOGGER.debug("trying to find {} in test files.");
        return (File)testFileContents.entrySet().stream().filter(entry -> ((String)entry.getValue()).contains(goTestMethodName)).findFirst().get().getKey();
    }

    private boolean stdoutContains(PackageTestResult result, String error) {
        return result.getStdout().stream().anyMatch(s -> s.contains(error));
    }

    private boolean testFailed(PackageTestResult result) {
        return !this.stdoutContains(result, TEST_START) && result.getCode() != 0;
    }

    private List<TestClassResult> testFailToStartUpResult(PackageTestResult testResult, String reason) {
        String message = String.join((CharSequence)"\n", testResult.getStdout());
        GoTestMethodResult ret = this.createTestMethodResult(reason, TestResult.ResultType.FAILURE, message, 0L);
        ret.addFailure(message, message, message);
        String className = this.determineClassName(testResult.getPackagePath(), reason);
        return Arrays.asList(this.methodResultsToClassResult(className, Arrays.asList(ret)));
    }

    protected String determineClassName(String packagePath, String fileName) {
        String escapedPackagePath = IOUtils.encodeInternally(packagePath);
        escapedPackagePath = escapedPackagePath.replaceAll("\\.", "_DOT_");
        return escapedPackagePath.replaceAll("%2F", ".") + "." + fileName.replaceAll("\\.", "_DOT_");
    }

    protected GoTestMethodResult createTestMethodResult(String testName, TestResult.ResultType resultType, String message, long duration) {
        GoTestMethodResult result = new GoTestMethodResult(testName, AbstractGoTestResultExtractor.extractGoTestMethodName(testName), resultType, duration, 0L, message);
        if (TestResult.ResultType.FAILURE == resultType) {
            result.addFailure(message, message, message);
        }
        return result;
    }

    private static String extractGoTestMethodName(String testName) {
        int indexOfSlash = testName.indexOf(47);
        if (indexOfSlash == -1) {
            return testName;
        }
        return testName.substring(0, indexOfSlash);
    }

    public static class GoTestMethodResult
    extends TestMethodResult {
        private String goTestMethodName;
        private String message;

        public String getMessage() {
            return this.message;
        }

        public String getGoTestMethodName() {
            return this.goTestMethodName;
        }

        public GoTestMethodResult(String name, String goTestMethodName, TestResult.ResultType resultType, long duration, long endTime, String message) {
            super(GLOBAL_COUNTER.incrementAndGet(), name, resultType, duration, 0L);
            this.message = message;
            this.goTestMethodName = goTestMethodName;
        }
    }
}

