/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import java.io.File;
import java.util.List;

public class PackageTestResult {
    private String packagePath;
    private List<File> testFiles;
    private List<String> stdout;
    private int code;

    public int getCode() {
        return this.code;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public List<File> getTestFiles() {
        return this.testFiles;
    }

    public List<String> getStdout() {
        return this.stdout;
    }

    public static PackageTestResultBuilder builder() {
        return new PackageTestResultBuilder();
    }

    public static final class PackageTestResultBuilder {
        private String packagePath;
        private List<File> testFiles;
        private List<String> stdout;
        private int code;

        private PackageTestResultBuilder() {
        }

        public PackageTestResultBuilder withPackagePath(String packagePath) {
            this.packagePath = packagePath;
            return this;
        }

        public PackageTestResultBuilder withTestFiles(List<File> testFiles) {
            this.testFiles = testFiles;
            return this;
        }

        public PackageTestResultBuilder withStdout(List<String> stdout) {
            this.stdout = stdout;
            return this;
        }

        public PackageTestResultBuilder withCode(int code) {
            this.code = code;
            return this;
        }

        public PackageTestResult build() {
            PackageTestResult ret = new PackageTestResult();
            ret.stdout = this.stdout;
            ret.testFiles = this.testFiles;
            ret.packagePath = this.packagePath;
            ret.code = this.code;
            return ret;
        }
    }
}

