/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.Go;
import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.common.GoSourceCodeFilter;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class GoVet
extends Go {
    @Inject
    private GolangPluginSetting setting;
    @Inject
    private GoBinaryManager goBinaryManager;
    private boolean verbose;

    public GoVet() {
        this.setDescription("Run 'go vet' (https://golang.org/cmd/vet).");
        this.dependsOn(new Object[]{"goVendor"});
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void afterEvaluate() {
        if (CollectionUtils.isEmpty(this.goActions)) {
            this.defaultVet();
        }
    }

    private void defaultVet() {
        this.goActions.add(new Go.GoAction(){

            @Override
            public Integer get() {
                List packagesToVet = GoVet.this.getPackagesToVet();
                if (packagesToVet.isEmpty()) {
                    LOGGER.quiet("No valid packages found, skip.");
                    return 0;
                }
                List<String> vetCommands = GoVet.this.verbose ? CollectionUtils.asStringList("vet", "-v", packagesToVet) : CollectionUtils.asStringList("vet", packagesToVet);
                return GoVet.this.buildManager.go(vetCommands, this.getEnvironment(), this.getStdoutLineConsumer(), this.getStderrLineConsumer(), this.isContinueOnFailure());
            }
        });
    }

    private List<String> getPackagesToVet() {
        if (this.goBinaryManager.goVetIgnoreVendor() && !this.isProjectGopath()) {
            return Collections.singletonList(this.setting.getPackagePath() + "/...");
        }
        return new ArrayList<String>(GoSourceCodeFilter.filterGoFiles(this.getProjectDir(), GoSourceCodeFilter.SourceSetType.PROJECT_ALL_FILES_ONLY).stream().map(File::getParentFile).map(this::getPackagePath).collect(Collectors.toSet()));
    }

    private String getPackagePath(File subDirPath) {
        if (subDirPath.equals(this.getProjectDir())) {
            return this.setting.getPackagePath();
        }
        Path relativePath = this.getProjectDir().toPath().relativize(subDirPath.toPath());
        return this.setting.getPackagePath() + "/" + StringUtils.toUnixString(relativePath);
    }

    private boolean isProjectGopath() {
        return this.buildManager.getGopath().contains(".gogradle/project_gopath");
    }
}

