/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.StandardGolangPackage;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class StandardPackagePathResolver
implements PackagePathResolver {
    private final Set<String> standardFirstLevelPackages = Sets.newHashSet((Object[])new String[]{"C", "archive", "bufio", "builtin", "bytes", "compress", "container", "context", "crypto", "database", "debug", "encoding", "errors", "expvar", "flag", "fmt", "go", "hash", "html", "image", "index", "io", "log", "math", "mime", "net", "os", "path", "reflect", "regexp", "runtime", "sort", "strconv", "strings", "sync", "syscall", "testing", "text", "time", "unicode", "unsafe", "plugin"});

    @Override
    @DebugLog
    public Optional<GolangPackage> produce(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        if (this.isStandardPackage(path)) {
            return Optional.of(StandardGolangPackage.of(path));
        }
        return Optional.empty();
    }

    public boolean isStandardPackage(Path path) {
        return path.getNameCount() > 0 && this.standardFirstLevelPackages.contains(path.getName(0).toString());
    }
}

