/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.exceptions;

import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class ResolutionStackWrappingException
extends RuntimeException {
    private ResolutionStackWrappingException(String message, Throwable cause) {
        super(message, cause);
    }

    public static ResolutionStackWrappingException wrapWithResolutionStack(Throwable e, ResolveContext context) {
        ArrayDeque<GolangDependency> resolutionStack = new ArrayDeque<GolangDependency>();
        while (context != null) {
            resolutionStack.addFirst(context.getDependency());
            context = context.getParent();
        }
        StringBuilder message = new StringBuilder("Exception in resolution, message is:\n");
        message.append(e.getMessage()).append("\n");
        message.append("Resolution stack is:\n");
        AtomicInteger counter = new AtomicInteger(0);
        resolutionStack.forEach(dependency -> {
            StringUtils.appendNSpaces(message, counter.getAndIncrement());
            message.append("+- ").append(dependency.resolve(null).toString()).append("\n");
        });
        return new ResolutionStackWrappingException(message.toString(), e);
    }
}

