/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.resolve;

import com.github.blindpirate.gogradle.core.cache.ProjectCacheManager;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.resolve.DependencyManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public interface CacheEnabledDependencyResolverMixin
extends DependencyManager {
    public static final Logger LOGGER = Logging.getLogger(CacheEnabledDependencyResolverMixin.class);

    @Override
    default public ResolvedDependency resolve(ResolveContext context, NotationDependency dependency) {
        AtomicBoolean functionInvoked = new AtomicBoolean(false);
        ResolvedDependency ret = this.getProjectCacheManager().resolve(dependency, (NotationDependency notationDependency) -> {
            functionInvoked.set(true);
            return this.doResolve(context, (NotationDependency)notationDependency);
        });
        if (functionInvoked.get()) {
            LOGGER.quiet("Resolving {}", new Object[]{dependency});
        } else {
            LOGGER.quiet("Resolving cached {}", new Object[]{dependency});
        }
        return ret;
    }

    public ProjectCacheManager getProjectCacheManager();

    public ResolvedDependency doResolve(ResolveContext var1, NotationDependency var2);
}

