/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.external.gvtgbvendor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ManifestModel {
    @JsonProperty(value="generator")
    private String generator;
    @JsonProperty(value="dependencies")
    private List<DependenciesBean> dependencies;

    public List<Map<String, Object>> toNotations() {
        return this.dependencies.stream().map(DependenciesBean::toNotation).collect(Collectors.toList());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DependenciesBean {
        @JsonProperty(value="importpath")
        private String importpath;
        @JsonProperty(value="repository")
        private String repository;
        @JsonProperty(value="vcs")
        private String vcs;
        @JsonProperty(value="revision")
        private String revision;
        @JsonProperty(value="branch")
        private String branch;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="notests")
        private boolean notests;

        public Map<String, Object> toNotation() {
            Assert.isNotBlank(this.importpath);
            return MapUtils.asMapWithoutNull("vcs", this.vcs, "name", this.determineName(), "version", this.revision, "transitive", false);
        }

        private String determineName() {
            if (StringUtils.isBlank(this.path)) {
                return this.importpath;
            }
            Assert.isTrue(this.importpath.endsWith(this.path));
            return StringUtils.removeEnd(this.importpath, this.path);
        }
    }
}

