/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.antlr.GolangBuildInfoBaseListener;
import com.github.blindpirate.gogradle.antlr.GolangBuildInfoLexer;
import com.github.blindpirate.gogradle.antlr.GolangBuildInfoParser;
import com.github.blindpirate.gogradle.common.GoSourceCodeFilter;
import com.github.blindpirate.gogradle.common.InSubpackagesPredicate;
import com.github.blindpirate.gogradle.core.BuildConstraintManager;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

@Singleton
public class GoImportExtractor {
    private final BuildConstraintManager buildConstraintManager;

    @Inject
    public GoImportExtractor(BuildConstraintManager buildConstraintManager) {
        this.buildConstraintManager = buildConstraintManager;
    }

    public Set<String> getImportPaths(File projectDir, Set<String> subpackages, String configuration) {
        InSubpackagesPredicate inSubpackages = InSubpackagesPredicate.withRootDirAndSubpackages(projectDir, subpackages);
        return GoSourceCodeFilter.filterGoFiles(projectDir, configuration).stream().filter(inSubpackages::test).map(IOUtils::toString).map(this::extract).collect(HashSet::new, AbstractCollection::addAll, AbstractCollection::addAll);
    }

    private List<String> extract(String sourceFileContent) {
        GolangBuildInfoLexer lexer = new GolangBuildInfoLexer((CharStream)new ANTLRInputStream(sourceFileContent));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GolangBuildInfoParser parser = new GolangBuildInfoParser((TokenStream)tokens);
        GolangBuildInfoParser.SourceFileContext tree = parser.sourceFile();
        ParseTreeWalker walker = new ParseTreeWalker();
        ImportListener listener = new ImportListener();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        if (this.shouldBeIncluded(listener)) {
            return listener.importPaths;
        }
        return Collections.emptyList();
    }

    private boolean shouldBeIncluded(ImportListener listener) {
        return listener.buildTags.eval(this.buildConstraintManager.getAllConstraints());
    }

    private static final class BuildTerm {
        private String name;
        private boolean precededByExclamation;

        private BuildTerm(String name, boolean precededByExclamation) {
            this.name = name;
            this.precededByExclamation = precededByExclamation;
        }

        static BuildTerm yes(String name) {
            return new BuildTerm(name, false);
        }

        static BuildTerm no(String name) {
            return new BuildTerm(name, true);
        }

        public boolean eval(Set<String> ctx) {
            if (this.precededByExclamation) {
                return !ctx.contains(this.name);
            }
            return ctx.contains(this.name);
        }
    }

    private static final class BuildOption {
        private List<BuildTerm> buildTerms = new ArrayList<BuildTerm>();

        private BuildOption() {
        }

        public boolean eval(Set<String> ctx) {
            return this.buildTerms.stream().allMatch(term -> term.eval(ctx));
        }

        public void addBuildTerm(BuildTerm buildTerm) {
            this.buildTerms.add(buildTerm);
        }
    }

    private static final class BuildTag {
        private List<BuildOption> buildOptions = new ArrayList<BuildOption>();

        private BuildTag() {
        }

        public boolean eval(Set<String> ctx) {
            return this.buildOptions.stream().anyMatch(option -> option.eval(ctx));
        }

        public void addBuildOption(BuildOption buildOption) {
            this.buildOptions.add(buildOption);
        }

        BuildOption getLastBuildOption() {
            return this.buildOptions.get(this.buildOptions.size() - 1);
        }
    }

    private static final class BuildTags {
        private List<BuildTag> buildTags = new ArrayList<BuildTag>();

        private BuildTags() {
        }

        void addBuildTag(BuildTag tag) {
            this.buildTags.add(tag);
        }

        BuildTag getLastBuildTag() {
            return this.buildTags.get(this.buildTags.size() - 1);
        }

        boolean eval(Set<String> ctx) {
            return this.buildTags.stream().allMatch(tag -> tag.eval(ctx));
        }
    }

    private static class ImportListener
    extends GolangBuildInfoBaseListener {
        private List<String> importPaths = new ArrayList<String>();
        private BuildTags buildTags = new BuildTags();

        private ImportListener() {
        }

        @Override
        public void enterImportPath(GolangBuildInfoParser.ImportPathContext ctx) {
            String importPath = StringUtils.substring(ctx.STRING_LIT().getText(), 1, -1);
            this.importPaths.add(importPath);
        }

        @Override
        public void enterBuildTag(GolangBuildInfoParser.BuildTagContext ctx) {
            this.buildTags.addBuildTag(new BuildTag());
        }

        @Override
        public void enterBuildOption(GolangBuildInfoParser.BuildOptionContext ctx) {
            this.buildTags.getLastBuildTag().addBuildOption(new BuildOption());
        }

        @Override
        public void enterBuildTerm(GolangBuildInfoParser.BuildTermContext ctx) {
            if (this.parentIsOption(ctx)) {
                BuildTerm term = this.getTerm(ctx);
                this.buildTags.getLastBuildTag().getLastBuildOption().addBuildTerm(term);
            }
        }

        private BuildTerm getTerm(GolangBuildInfoParser.BuildTermContext ctx) {
            if (this.sonAndGrandsonBothHaveExclamation(ctx)) {
                throw new IllegalStateException("!!term is not supported!");
            }
            if (this.sonHasExclamation(ctx)) {
                return BuildTerm.no(this.getTermNameOfSon(ctx));
            }
            return BuildTerm.yes(this.getTermName(ctx));
        }

        private String getTermName(GolangBuildInfoParser.BuildTermContext ctx) {
            return ctx.IDENTIFIER().getText();
        }

        private String getTermNameOfSon(GolangBuildInfoParser.BuildTermContext ctx) {
            return ((GolangBuildInfoParser.BuildTermContext)ctx.getChild(GolangBuildInfoParser.BuildTermContext.class, 0)).IDENTIFIER().getText();
        }

        private boolean sonHasExclamation(GolangBuildInfoParser.BuildTermContext ctx) {
            return "!".equals(ctx.getChild(0).getText());
        }

        private boolean parentIsOption(GolangBuildInfoParser.BuildTermContext ctx) {
            return ctx.getParent() instanceof GolangBuildInfoParser.BuildOptionContext;
        }

        private boolean sonAndGrandsonBothHaveExclamation(GolangBuildInfoParser.BuildTermContext ctx) {
            return "!".equals(ctx.getChild(0).getText()) && "!".equals(ctx.getChild(1).getChild(0).getText());
        }
    }
}

