/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.dependency.AbstractNotationDependency;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.VendorResolvedDependency;
import com.github.blindpirate.gogradle.core.exceptions.DependencyResolutionException;
import java.util.Objects;
import java.util.Optional;

public class VendorNotationDependency
extends AbstractNotationDependency {
    private NotationDependency hostNotationDependency;
    private String vendorPath;

    public String getVendorPath() {
        return this.vendorPath;
    }

    public NotationDependency getHostNotationDependency() {
        return this.hostNotationDependency;
    }

    public void setHostNotationDependency(NotationDependency hostNotationDependency) {
        this.hostNotationDependency = hostNotationDependency;
    }

    public void setVendorPath(String vendorPath) {
        this.vendorPath = vendorPath;
    }

    @Override
    public ResolvedDependency doResolve(ResolveContext context) {
        ResolveContext rootContext = ResolveContext.root(this.hostNotationDependency, context.getConfiguration());
        ResolvedDependency hostResolvedDependency = this.hostNotationDependency.resolve(rootContext);
        Optional<VendorResolvedDependency> result = hostResolvedDependency.getDependencies().flatten().stream().filter(d -> d instanceof VendorResolvedDependency).map(d -> (VendorResolvedDependency)d).filter(d -> d.getRelativePathToHost().equals(this.vendorPath)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw DependencyResolutionException.vendorNotExist(this, hostResolvedDependency);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        VendorNotationDependency that = (VendorNotationDependency)o;
        return Objects.equals(this.hostNotationDependency, that.hostNotationDependency) && Objects.equals(this.vendorPath, that.vendorPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hostNotationDependency, this.vendorPath);
    }

    @Override
    public String getVersion() {
        return this.hostNotationDependency + "/" + this.vendorPath;
    }

    @Override
    public CacheScope getCacheScope() {
        return this.hostNotationDependency.getCacheScope();
    }
}

