/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.GolangConfiguration;
import com.github.blindpirate.gogradle.core.cache.ProjectCacheManager;
import com.github.blindpirate.gogradle.core.dependency.DependencyRegistry;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.VendorResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.strategy.DependencyProduceStrategy;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

public class ResolveContext {
    private ResolveContext parent;
    private GolangConfiguration configuration;
    private DependencyProduceStrategy dependencyProduceStrategy;
    private GolangDependency dependency;
    private Set<Predicate<GolangDependency>> transitiveDepExclusions = Collections.emptySet();

    public GolangConfiguration getConfiguration() {
        return this.configuration;
    }

    public DependencyRegistry getDependencyRegistry() {
        return this.configuration.getDependencyRegistry();
    }

    public ResolveContext createSubContext(GolangDependency dependency) {
        return new ResolveContext(this, this.configuration, dependency, this.dependencyProduceStrategy);
    }

    public static ResolveContext root(GolangDependency rootDependency, GolangConfiguration configuration) {
        return new ResolveContext(null, configuration, rootDependency, DependencyProduceStrategy.DEFAULT_STRATEGY);
    }

    private ResolveContext(ResolveContext parent, GolangConfiguration configuration, GolangDependency dependency, DependencyProduceStrategy strategy) {
        this.parent = parent;
        this.configuration = configuration;
        this.dependencyProduceStrategy = strategy;
        this.dependency = dependency;
        if (dependency instanceof NotationDependency) {
            this.transitiveDepExclusions = ((NotationDependency)NotationDependency.class.cast(dependency)).getTransitiveDepExclusions();
        }
    }

    public GolangDependencySet produceTransitiveDependencies(ResolvedDependency dependency, File rootDir) {
        DependencyVisitor visitor = GogradleGlobal.getInstance(DependencyVisitor.class);
        ProjectCacheManager projectCacheManager = GogradleGlobal.getInstance(ProjectCacheManager.class);
        GolangDependencySet ret = projectCacheManager.produce(dependency, resolvedDependency -> this.dependencyProduceStrategy.produce(dependency, rootDir, visitor, "build"));
        return this.filterRecursively(ret);
    }

    private GolangDependencySet filterRecursively(GolangDependencySet set) {
        GolangDependencySet ret = set.stream().filter(this::shouldBeReserved).collect(GolangDependencySet.COLLECTOR);
        ret.forEach(dependency -> {
            if (dependency instanceof VendorResolvedDependency) {
                VendorResolvedDependency vendorResolvedDependency = (VendorResolvedDependency)dependency;
                vendorResolvedDependency.setDependencies(this.filterRecursively(vendorResolvedDependency.getDependencies()));
            }
        });
        return ret;
    }

    private boolean shouldBeReserved(GolangDependency dependency) {
        ResolveContext current = this;
        while (current != null) {
            if (current.transitiveDepExclusions.stream().anyMatch(predicate -> predicate.test(dependency))) {
                return false;
            }
            current = current.parent;
        }
        return true;
    }

    public GolangDependency getDependency() {
        return this.dependency;
    }

    public ResolveContext getParent() {
        return this.parent;
    }
}

