/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.dependency.AbstractGolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.VendorResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.resolve.DependencyManager;
import com.github.blindpirate.gogradle.util.Assert;
import java.io.File;
import java.util.Objects;

public abstract class AbstractResolvedDependency
extends AbstractGolangDependency
implements ResolvedDependency {
    private String version;
    private long updateTime;
    private GolangDependencySet dependencies = GolangDependencySet.empty();

    protected AbstractResolvedDependency(String name, String version, long updateTime) {
        this.setName(name);
        this.version = version;
        this.updateTime = updateTime;
    }

    public void setDependencies(GolangDependencySet dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public ResolvedDependency resolve(ResolveContext context) {
        return this;
    }

    @Override
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public GolangDependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public void installTo(File targetDirectory) {
        this.getInstaller().install(this, targetDirectory);
    }

    protected abstract DependencyManager getInstaller();

    @Override
    public String toString() {
        return this.getName() + ":" + this.formatVersion();
    }

    @Override
    public CacheScope getCacheScope() {
        return CacheScope.PERSISTENCE;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractResolvedDependency that = (AbstractResolvedDependency)o;
        return Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version);
    }

    @Override
    public Object clone() {
        AbstractResolvedDependency ret = (AbstractResolvedDependency)super.clone();
        Assert.isTrue(this.onlyVendorDependenciesCanHaveDescendants());
        ret.dependencies = this.dependencies.clone();
        if (this.getClass() != VendorResolvedDependency.class) {
            ret.dependencies.flatten().forEach(dependency -> this.resetVendorHostIfNecessary((GolangDependency)dependency, ret));
        }
        return ret;
    }

    private boolean onlyVendorDependenciesCanHaveDescendants() {
        return this.dependencies.stream().filter(d -> d instanceof ResolvedDependency && !(d instanceof VendorResolvedDependency)).map(d -> (ResolvedDependency)d).allMatch(d -> d.getDependencies().isEmpty());
    }

    private void resetVendorHostIfNecessary(GolangDependency dependency, ResolvedDependency clone) {
        if (dependency instanceof VendorResolvedDependency) {
            ((VendorResolvedDependency)VendorResolvedDependency.class.cast(dependency)).setHostDependency(clone);
        }
    }
}

