/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.github.blindpirate.gogradle.core.cache.PersistenceCache;
import com.github.blindpirate.gogradle.util.ExceptionHandler;
import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.File;
import java.io.UncheckedIOException;
import java.util.Map;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public interface PersistenceCacheHelper {
    public static final Logger LOGGER = Logging.getLogger(PersistenceCache.class);

    public static void load(Map cache, File persistenceFile) {
        if (persistenceFile.exists()) {
            try {
                cache.putAll((Map)IOUtils.deserialize(persistenceFile));
            }
            catch (ExceptionHandler.UncheckedException e) {
                LOGGER.warn("Exception in deserializing dependency cache, skip.");
                LOGGER.info("", (Throwable)e);
            }
        } else {
            LOGGER.info("Cache {} not found, skip.", (Object)persistenceFile);
        }
    }

    public static void save(Object cache, File persistenceFile) {
        try {
            IOUtils.serialize(cache, persistenceFile);
        }
        catch (UncheckedIOException e) {
            LOGGER.warn("Exception in serializing dependency cache, skip.");
            LOGGER.info("", (Throwable)e);
        }
    }
}

