/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.blindpirate.gogradle.common.WithApiVersion;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class GlobalCacheMetadata
extends WithApiVersion {
    @JsonProperty(value="package")
    private String pkg;
    @JsonProperty(value="repositories")
    private List<GolangRepositoryMetadata> repositories;
    @JsonIgnore
    private boolean dirty;

    public static GlobalCacheMetadata newMetadata(VcsGolangPackage pkg) {
        GlobalCacheMetadata metadata = new GlobalCacheMetadata();
        metadata.pkg = pkg.getRootPathString();
        metadata.repositories = new ArrayList<GolangRepositoryMetadata>();
        metadata.repositories.add(new GolangRepositoryMetadata(pkg.getRepository()));
        metadata.dirty = true;
        return metadata;
    }

    public List<GolangRepositoryMetadata> getRepositories() {
        return this.repositories;
    }

    public void addRepository(GolangRepository repository) {
        this.dirty = true;
        this.repositories.add(new GolangRepositoryMetadata(repository));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getPackage() {
        return this.pkg;
    }

    public static class GolangRepositoryMetadata
    extends GolangRepository {
        @JsonProperty(value="lastUpdatedTime")
        private long lastUpdatedTime;
        @JsonProperty(value="dir")
        private String dir;

        public GolangRepositoryMetadata() {
        }

        private GolangRepositoryMetadata(GolangRepository repository) {
            this.urls = repository.getUrls();
            this.dir = this.getUrlHash();
            this.original = repository.isOriginal();
            this.vcs = repository.getVcsType();
        }

        public long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public void updated() {
            this.lastUpdatedTime = System.currentTimeMillis();
        }

        public String getDir() {
            return this.dir;
        }

        private String getUrlHash() {
            String combined = String.join((CharSequence)"", CollectionUtils.toSorted(this.getUrls()));
            return DigestUtils.md5Hex((String)combined);
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

