/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.IncompleteGolangPackage;
import com.github.blindpirate.gogradle.core.ResolvableGolangPackage;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class VcsGolangPackage
extends ResolvableGolangPackage {
    private GolangRepository repository;

    protected VcsGolangPackage(Path rootPath, Path path) {
        super(rootPath, path);
    }

    @Override
    protected Optional<GolangPackage> longerPath(Path packagePath) {
        return Optional.of(this.sameRoot(packagePath));
    }

    @Override
    protected Optional<GolangPackage> shorterPath(Path packagePath) {
        if (packagePath.getNameCount() < this.getRootPath().getNameCount()) {
            return Optional.of(IncompleteGolangPackage.of(packagePath));
        }
        return Optional.of(this.sameRoot(packagePath));
    }

    private GolangPackage sameRoot(Path packagePath) {
        return VcsGolangPackage.builder().withPath(packagePath).withRootPath(this.getRootPath()).withRepository(this.repository).build();
    }

    public GolangRepository getRepository() {
        return this.repository;
    }

    public VcsType getVcsType() {
        return this.repository.getVcsType();
    }

    public List<String> getUrls() {
        return this.repository.getUrls();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "VcsGolangPackage{path='" + this.getPathString() + '\'' + ", rootPath='" + this.getRootPathString() + '\'' + ", vcsType=" + (Object)((Object)this.getVcsType()) + ", urls='" + this.getUrls() + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        VcsGolangPackage that = (VcsGolangPackage)o;
        return Objects.equals(this.repository, that.repository);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.repository);
    }

    public static final class Builder {
        private Path path;
        private Path rootPath;
        private GolangRepository repository;

        private Builder() {
        }

        public Builder withPath(String path) {
            return this.withPath(Paths.get(path, new String[0]));
        }

        public Builder withRootPath(String rootPath) {
            return this.withRootPath(Paths.get(rootPath, new String[0]));
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withRootPath(Path rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder withRepository(GolangRepository repository) {
            this.repository = repository;
            return this;
        }

        public VcsGolangPackage build() {
            VcsGolangPackage ret = new VcsGolangPackage(this.rootPath, this.path);
            Assert.isNotNull(this.repository);
            ret.repository = this.repository;
            return ret;
        }
    }
}

