/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GolangRepository
implements Serializable {
    @JsonProperty(value="urls")
    protected List<String> urls;
    protected VcsType vcs;
    @JsonProperty(value="original")
    protected boolean original;

    public String getVcs() {
        return this.vcs.getName();
    }

    @JsonIgnore
    public VcsType getVcsType() {
        return this.vcs;
    }

    public void setVcs(String vcs) {
        this.vcs = VcsType.of(vcs).get();
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public static GolangRepository newOriginalRepository(VcsType vcs, String url) {
        return GolangRepository.builder().withUrls(Collections.singletonList(url)).withVcs(vcs).withOriginal(true).build();
    }

    public static GolangRepository newOriginalRepository(String vcs, List<String> urls) {
        return GolangRepository.newOriginalRepository(VcsType.of(vcs).get(), urls);
    }

    public static GolangRepository newOriginalRepository(VcsType vcs, List<String> urls) {
        return GolangRepository.builder().withUrls(urls).withVcs(vcs).withOriginal(true).build();
    }

    public static GolangRepository newSubstitutedRepository(VcsType vcs, String url) {
        return GolangRepository.newSubstitutedRepository(vcs, Collections.singletonList(url));
    }

    public static GolangRepository newSubstitutedRepository(VcsType vcs, List<String> urls) {
        return GolangRepository.builder().withUrls(urls).withVcs(vcs).withOriginal(false).build();
    }

    public static GolangRepositoryBuilder builder() {
        return new GolangRepositoryBuilder();
    }

    public boolean match(GolangRepository anotherRepo) {
        return CollectionUtils.containsAny(this.getUrls(), anotherRepo.getUrls());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GolangRepository that = (GolangRepository)o;
        return !CollectionUtils.intersection(this.urls, that.urls).isEmpty() && this.vcs == that.vcs;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vcs});
    }

    public static final class GolangRepositoryBuilder {
        private List<String> urls;
        private VcsType vcs;
        private boolean original;

        private GolangRepositoryBuilder() {
        }

        public GolangRepositoryBuilder withUrls(List<String> urls) {
            this.urls = urls;
            return this;
        }

        public GolangRepositoryBuilder withVcs(VcsType vcs) {
            this.vcs = vcs;
            return this;
        }

        public GolangRepositoryBuilder withOriginal(boolean original) {
            this.original = original;
            return this;
        }

        public GolangRepository build() {
            GolangRepository golangRepository = new GolangRepository();
            golangRepository.urls = this.urls;
            golangRepository.vcs = this.vcs;
            golangRepository.original = this.original;
            return golangRepository;
        }
    }
}

