/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.core.GolangConfiguration;
import com.github.blindpirate.gogradle.core.GolangConfigurationManager;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gradle.util.CollectionUtils;

@Singleton
public class GolangDependencyHandler
extends GroovyObjectSupport {
    private final GolangConfigurationManager configurationManager;

    @Inject
    public GolangDependencyHandler(GolangConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public Object methodMissing(String name, Object args) {
        Object[] argsArray = (Object[])args;
        GolangConfiguration configuration = this.configurationManager.getByName(name);
        if (configuration == null) {
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), argsArray);
        }
        List normalizedArgs = CollectionUtils.flattenCollections((Object[])argsArray);
        if (normalizedArgs.size() == 2 && normalizedArgs.get(1) instanceof Closure) {
            this.doAdd(configuration, normalizedArgs.get(0), (Closure)normalizedArgs.get(1));
        } else if (normalizedArgs.size() == 1) {
            this.doAdd(configuration, normalizedArgs.get(0), null);
        } else {
            for (Object arg : normalizedArgs) {
                this.doAdd(configuration, arg, null);
            }
        }
        return null;
    }

    private void doAdd(GolangConfiguration configuration, Object dependencyNotation, Closure configureClosure) {
        configuration.addFirstLevelDependency(dependencyNotation, configureClosure);
    }
}

