/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.core.dependency.AbstractGolangDependency;
import com.github.blindpirate.gogradle.core.dependency.DefaultDependencyRegistry;
import com.github.blindpirate.gogradle.core.dependency.DependencyRegistry;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.parse.NotationParser;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.util.ConfigureUtil;

public class GolangConfiguration {
    public static final String BUILD = "build";
    public static final String TEST = "test";
    private final String name;
    private final GolangDependencySet dependencies = new GolangDependencySet();
    private final DependencyRegistry dependencyRegistry;
    private final List<Pair<Object, Closure>> firstLevelDependencies = new ArrayList<Pair<Object, Closure>>();
    private final NotationParser<Object> notationParser;
    private boolean resolved;

    public GolangConfiguration(String name, NotationParser notationParser, PackagePathResolver packagePathResolver) {
        this.name = name;
        this.notationParser = notationParser;
        this.dependencyRegistry = new DefaultDependencyRegistry(packagePathResolver);
    }

    public DependencyRegistry getDependencyRegistry() {
        return this.dependencyRegistry;
    }

    public GolangDependencySet getDependencies() {
        if (!this.resolved) {
            this.resolved = true;
            this.firstLevelDependencies.forEach(pair -> this.dependencies.add(this.create(pair.getLeft(), (Closure)pair.getRight())));
        }
        return this.dependencies;
    }

    public String getName() {
        return this.name;
    }

    public void addFirstLevelDependency(Object notation, Closure closure) {
        this.firstLevelDependencies.add((Pair<Object, Closure>)Pair.of((Object)notation, (Object)closure));
    }

    public GolangDependency create(Object dependencyNotation, Closure configureClosure) {
        GolangDependency dependency = this.notationParser.parse(dependencyNotation);
        ((AbstractGolangDependency)AbstractGolangDependency.class.cast(dependency)).setFirstLevel(true);
        return (GolangDependency)ConfigureUtil.configure((Closure)configureClosure, (Object)dependency);
    }

    public boolean hasFirstLevelDependencies() {
        return !this.firstLevelDependencies.isEmpty();
    }
}

