/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.core.BuildConstraintManager;
import com.github.blindpirate.gogradle.crossplatform.Arch;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.crossplatform.Os;
import com.github.blindpirate.gogradle.util.Assert;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultBuildConstraintManager
implements BuildConstraintManager {
    private static final Pattern GO_VERSION_REGEX = Pattern.compile("(\\d+)\\.(\\d+).*");
    private final GoBinaryManager goBinaryManager;
    private final GolangPluginSetting setting;
    private Set<String> allConstraints;

    @Inject
    public DefaultBuildConstraintManager(GoBinaryManager goBinaryManager, GolangPluginSetting setting) {
        this.goBinaryManager = goBinaryManager;
        this.setting = setting;
    }

    @Override
    public void prepareConstraints() {
        HashSet<String> tmpAllConstraints = new HashSet<String>();
        tmpAllConstraints.add(Os.getHostOs().toString());
        tmpAllConstraints.add(Arch.getHostArch().toString());
        tmpAllConstraints.addAll(this.allGoVersionConstraints());
        tmpAllConstraints.addAll(this.setting.getBuildTags());
        this.allConstraints = Collections.unmodifiableSet(tmpAllConstraints);
    }

    private Set<String> allGoVersionConstraints() {
        HashSet<String> ret = new HashSet<String>();
        String goVersion = this.goBinaryManager.getGoVersion();
        Matcher m = GO_VERSION_REGEX.matcher(goVersion);
        Assert.isTrue(m.find(), "Unrecognized version:" + goVersion);
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        Assert.isTrue(major == 1, "Only go1 is supported!");
        for (int i = 1; i <= minor; ++i) {
            ret.add("go1." + i);
        }
        return ret;
    }

    @Override
    public Set<String> getAllConstraints() {
        return this.allConstraints;
    }
}

