/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.common;

import com.github.blindpirate.gogradle.util.Assert;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Predicate;

public class InSubpackagesPredicate
implements Predicate<File> {
    private boolean alwaysTrue;
    private File rootDir;
    private Set<String> subpackages;

    public static InSubpackagesPredicate withRootDirAndSubpackages(File rootDir, Set<String> subpackages) {
        InSubpackagesPredicate ret = new InSubpackagesPredicate();
        if (subpackages.contains("...")) {
            ret.alwaysTrue = true;
        } else {
            ret.rootDir = rootDir;
            ret.subpackages = subpackages;
        }
        return ret;
    }

    private InSubpackagesPredicate() {
    }

    @Override
    public boolean test(File file) {
        Assert.isTrue(file.isFile());
        if (this.alwaysTrue) {
            return true;
        }
        Assert.isTrue(file.toPath().startsWith(this.rootDir.toPath()));
        return this.subpackages.stream().anyMatch(subpackage -> this.fileIsInSubpackage(file, this.rootDir, (String)subpackage));
    }

    private boolean fileIsInSubpackage(File file, File rootDir, String subpackage) {
        if (".".equals(subpackage)) {
            return file.getParentFile().equals(rootDir);
        }
        if (subpackage.endsWith("/.")) {
            String withoutDot = subpackage.substring(0, subpackage.length() - 2);
            return file.getParentFile().toPath().equals(rootDir.toPath().resolve(withoutDot).normalize());
        }
        Path subpackagePath = rootDir.toPath().resolve(subpackage);
        return file.toPath().startsWith(subpackagePath.normalize());
    }
}

