/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.GogradleModule;
import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.GolangRepositoryHandler;
import com.github.blindpirate.gogradle.core.GolangDependencyHandler;
import com.github.blindpirate.gogradle.core.mode.BuildMode;
import com.github.blindpirate.gogradle.core.pack.GloballyIgnoredPackages;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.task.GolangTaskContainer;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;

public class GolangPlugin
implements Plugin<Project> {
    public static final String GOGRADLE_INJECTOR = "GOGRADLE_INJECTOR";
    private static final Logger LOGGER = Logging.getLogger(GolangPlugin.class);
    private Injector injector;
    private GolangPluginSetting settings;
    private GolangTaskContainer golangTaskContainer;
    private GolangRepositoryHandler golangRepositoryHandler;
    private Project project;

    public void apply(Project project) {
        this.init(project);
        this.configureGogradleGlobal();
        this.customizeProjectInternalServices(project);
        this.configureSettings(project);
        this.configureConfigurations(project);
        this.createCoreTasks(project);
    }

    private void init(Project project) {
        this.project = project;
        this.injector = this.initGuice();
        project.getExtensions().add(GOGRADLE_INJECTOR, (Object)this.injector);
        GogradleGlobal.INSTANCE.setCurrentProject(project);
        this.settings = (GolangPluginSetting)this.injector.getInstance(GolangPluginSetting.class);
        this.golangTaskContainer = ((GolangTaskContainer)this.injector.getInstance(GolangTaskContainer.class)).init(project, this.injector);
        this.golangRepositoryHandler = (GolangRepositoryHandler)((Object)this.injector.getInstance(GolangRepositoryHandler.class));
        Arrays.asList(BuildMode.values()).forEach(mode -> {
            project.getExtensions().add(BuildMode.class, mode.toString(), (Object)mode);
            project.getExtensions().add(BuildMode.class, mode.getAbbr(), (Object)mode);
        });
        Arrays.asList(TimeUnit.values()).forEach(timeUnit -> {
            String name = timeUnit.name();
            project.getExtensions().add(TimeUnit.class, name, (Object)timeUnit);
            project.getExtensions().add(TimeUnit.class, name.substring(0, name.length() - 1), (Object)timeUnit);
        });
    }

    private Injector initGuice() {
        return Guice.createInjector((Module[])new Module[]{new GogradleModule(this.project)});
    }

    private void configureGogradleGlobal() {
        GogradleGlobal.INSTANCE.setCurrentProject(this.project);
    }

    private void createCoreTasks(Project project) {
        this.golangTaskContainer.createCoreTasks();
        project.afterEvaluate(this::afterEvaluate);
    }

    private void afterEvaluate(Project project) {
        this.golangTaskContainer.forEach(task -> {
            if (task instanceof AbstractGolangTask) {
                ((AbstractGolangTask)((Object)((Object)AbstractGolangTask.class.cast(task)))).afterEvaluate();
            }
        });
        this.registerGloballyIgnoredPackages();
    }

    private void registerGloballyIgnoredPackages() {
        if (!this.settings.isUserHasCustomizedIgnoredPackages()) {
            this.settings.setIgnoredPackages(GloballyIgnoredPackages.PKGS);
        }
        if (!this.settings.getIgnoredPackages().isEmpty()) {
            LOGGER.info("Ignore packages globally: {}", (Object)String.join((CharSequence)",", this.settings.getIgnoredPackages()));
            this.settings.getIgnoredPackages().forEach(this.golangRepositoryHandler::addEmptyRepo);
        }
    }

    private void customizeProjectInternalServices(Project project) {
        this.bindCustomizedService(project.getRepositories(), this.injector.getInstance(GolangRepositoryHandler.class));
        this.bindCustomizedService(project.getDependencies(), this.injector.getInstance(GolangDependencyHandler.class));
    }

    private void bindCustomizedService(Object target, Object customizedService) {
        ((ExtensionAware)ExtensionAware.class.cast(target)).getExtensions().add("golang", customizedService);
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Arrays.asList("build", "test").forEach(arg_0 -> ((ConfigurationContainer)configurations).create(arg_0));
    }

    private void configureSettings(Project project) {
        project.getExtensions().add("golang", (Object)this.settings);
    }
}

