/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle;

import com.google.inject.Injector;
import com.google.inject.Key;
import org.gradle.api.Project;

public enum GogradleGlobal {
    INSTANCE;

    public static final String GOGRADLE_VERSION = "0.11.4";
    public static final String GOGRADLE_COMPATIBLE_VERSION = "0.10";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String GOGRADLE_BUILD_DIR_NAME = ".gogradle";
    public static final int MAX_DFS_DEPTH = 100;
    public static final String GOGRADLE_REFRESH = "gogradle.refresh";
    public static final String GOGRADLE_MODE = "gogradle.mode";
    private ThreadLocal<Injector> currentInjector = new ThreadLocal();

    public Injector getInjector() {
        return this.currentInjector.get();
    }

    public void setCurrentProject(Project project) {
        if (project == null) {
            this.currentInjector.set(null);
        } else {
            this.currentInjector.set((Injector)project.getExtensions().getByName("GOGRADLE_INJECTOR"));
        }
    }

    public static <T> T getInstance(Class<T> clazz) {
        return (T)INSTANCE.getInjector().getInstance(clazz);
    }

    public static boolean isOffline() {
        return GogradleGlobal.getInstance(Project.class).getGradle().getStartParameter().isOffline();
    }

    public static boolean isRefreshDependencies() {
        return GogradleGlobal.getInstance(Project.class).getGradle().getStartParameter().isRefreshDependencies() || "true".equals(System.getProperty(GOGRADLE_REFRESH));
    }

    public static String getMode() {
        String mode = System.getProperty(GOGRADLE_MODE);
        return mode == null ? "" : mode;
    }

    public static <T> T getInstance(Key<T> key) {
        return (T)INSTANCE.getInjector().getInstance(key);
    }
}

