/*
 * Copyright 2016-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *           http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.github.blindpirate.gogradle.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class IncompleteGolangPackage extends GolangPackage {
    private IncompleteGolangPackage(Path path) {
        super(path);
    }

    @Override
    protected Optional<GolangPackage> longerPath(Path packagePath) {
        return Optional.empty();
    }

    @Override
    protected Optional<GolangPackage> shorterPath(Path packagePath) {
        return Optional.of(of(packagePath));
    }

    public static IncompleteGolangPackage of(Path path) {
        return new IncompleteGolangPackage(path);
    }

    public static IncompleteGolangPackage of(String path) {
        return of(Paths.get(path));
    }

    @Override
    public String toString() {
        return "IncompleteGolangPackage{"
                + "path='" + getPathString() + '\''
                + '}';
    }
}
